/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.io.reactivex.subscribers;

import io.confluent.shaded.io.reactivex.FlowableSubscriber;
import io.confluent.shaded.io.reactivex.exceptions.CompositeException;
import io.confluent.shaded.io.reactivex.exceptions.Exceptions;
import io.confluent.shaded.io.reactivex.internal.subscriptions.EmptySubscription;
import io.confluent.shaded.io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.confluent.shaded.io.reactivex.plugins.RxJavaPlugins;
import io.confluent.shaded.org.reactivestreams.Subscriber;
import io.confluent.shaded.org.reactivestreams.Subscription;

public final class SafeSubscriber<T>
implements FlowableSubscriber<T>,
Subscription {
    final Subscriber<? super T> downstream;
    Subscription upstream;
    boolean done;

    public SafeSubscriber(Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.upstream, s)) {
            this.upstream = s;
            try {
                this.downstream.onSubscribe(this);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.done = true;
                try {
                    s.cancel();
                }
                catch (Throwable e1) {
                    Exceptions.throwIfFatal(e1);
                    RxJavaPlugins.onError(new CompositeException(e, e1));
                    return;
                }
                RxJavaPlugins.onError(e);
            }
        }
    }

    @Override
    public void onNext(T t) {
        if (this.done) {
            return;
        }
        if (this.upstream == null) {
            this.onNextNoSubscription();
            return;
        }
        if (t == null) {
            NullPointerException ex = new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources.");
            try {
                this.upstream.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(ex, e1));
                return;
            }
            this.onError(ex);
            return;
        }
        try {
            this.downstream.onNext(t);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.upstream.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                this.onError(new CompositeException(e, e1));
                return;
            }
            this.onError(e);
        }
    }

    void onNextNoSubscription() {
        this.done = true;
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.downstream.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            NullPointerException npe = new NullPointerException("Subscription not set!");
            try {
                this.downstream.onSubscribe(EmptySubscription.INSTANCE);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(new CompositeException(t, npe, e));
                return;
            }
            try {
                this.downstream.onError(new CompositeException(t, npe));
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                RxJavaPlugins.onError(new CompositeException(t, npe, e));
            }
            return;
        }
        if (t == null) {
            t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
        }
        try {
            this.downstream.onError(t);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            RxJavaPlugins.onError(new CompositeException(t, ex));
        }
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        if (this.upstream == null) {
            this.onCompleteNoSubscription();
            return;
        }
        try {
            this.downstream.onComplete();
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(e);
        }
    }

    void onCompleteNoSubscription() {
        NullPointerException ex = new NullPointerException("Subscription not set!");
        try {
            this.downstream.onSubscribe(EmptySubscription.INSTANCE);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
            return;
        }
        try {
            this.downstream.onError(ex);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            RxJavaPlugins.onError(new CompositeException(ex, e));
        }
    }

    @Override
    public void request(long n) {
        try {
            this.upstream.request(n);
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            try {
                this.upstream.cancel();
            }
            catch (Throwable e1) {
                Exceptions.throwIfFatal(e1);
                RxJavaPlugins.onError(new CompositeException(e, e1));
                return;
            }
            RxJavaPlugins.onError(e);
        }
    }

    @Override
    public void cancel() {
        try {
            this.upstream.cancel();
        }
        catch (Throwable e1) {
            Exceptions.throwIfFatal(e1);
            RxJavaPlugins.onError(e1);
        }
    }
}

