/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.shaded.org.asynchttpclient.extras.rxjava2;

import io.confluent.shaded.io.reactivex.Maybe;
import io.confluent.shaded.io.reactivex.MaybeEmitter;
import io.confluent.shaded.io.reactivex.disposables.Disposables;
import io.confluent.shaded.org.asynchttpclient.AsyncHandler;
import io.confluent.shaded.org.asynchttpclient.AsyncHttpClient;
import io.confluent.shaded.org.asynchttpclient.ListenableFuture;
import io.confluent.shaded.org.asynchttpclient.Request;
import io.confluent.shaded.org.asynchttpclient.extras.rxjava2.RxHttpClient;
import io.confluent.shaded.org.asynchttpclient.extras.rxjava2.maybe.MaybeAsyncHandlerBridge;
import io.confluent.shaded.org.asynchttpclient.extras.rxjava2.maybe.ProgressAsyncMaybeEmitterBridge;
import io.confluent.shaded.org.asynchttpclient.handler.ProgressAsyncHandler;
import java.util.Objects;
import java.util.function.Supplier;

public class DefaultRxHttpClient
implements RxHttpClient {
    private final AsyncHttpClient asyncHttpClient;

    public DefaultRxHttpClient(AsyncHttpClient asyncHttpClient) {
        this.asyncHttpClient = Objects.requireNonNull(asyncHttpClient);
    }

    @Override
    public <T> Maybe<T> prepare(Request request, Supplier<? extends AsyncHandler<T>> handlerSupplier) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(handlerSupplier);
        return Maybe.create((MaybeEmitter<T> emitter) -> {
            AsyncHandler<?> bridge = this.createBridge(emitter, (AsyncHandler)handlerSupplier.get());
            ListenableFuture<?> responseFuture = this.asyncHttpClient.executeRequest(request, bridge);
            emitter.setDisposable(Disposables.fromFuture(responseFuture));
        });
    }

    protected <T> AsyncHandler<?> createBridge(MaybeEmitter<T> emitter, AsyncHandler<T> handler) {
        if (handler instanceof ProgressAsyncHandler) {
            return new ProgressAsyncMaybeEmitterBridge<T>(emitter, (ProgressAsyncHandler)handler);
        }
        return new MaybeAsyncHandlerBridge<T>(emitter, handler);
    }
}

