/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import io.confluent.resourcemanager.api.client.Client;
import io.confluent.resourcemanager.api.client.CreateRequest;
import io.confluent.resourcemanager.api.client.DeleteRequest;
import io.confluent.resourcemanager.api.client.GetRequest;
import io.confluent.resourcemanager.api.client.ListRequest;
import io.confluent.resourcemanager.api.client.UpdateRequest;
import io.confluent.resourcemanager.api.client.Watcher;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.identifier.ObjectIdentifier;
import io.confluent.resourcemanager.api.openapi.Adapter;
import io.confluent.srj.spire.SpireX509Client;
import io.confluent.srj.spire.exceptions.SpiffeX509SourceProviderException;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLException;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public final class ClientImpl
implements Client {
    public static ObjectMapper OBJECT_MAPPER = new ObjectMapper().findAndRegisterModules().registerModule((Module)new Jdk8Module()).registerModule((Module)new ProtobufModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final String DEFAULT_USER_AGENT = ClientImpl.buildUserAgent();
    static final String USER_AGENT_HEADER = "User-Agent";
    private final String httpHost;
    private final OkHttpClient httpClient;
    private final ManagedChannel channel;
    private String userAgent;

    public static ClientImpl spire(String spireAgentUrl, String authorizedSpiffeIds, String httpHost, String grpcHost) throws KeyManagementException, SSLException, NoSuchAlgorithmException, SpiffeX509SourceProviderException {
        return ClientImpl.spire(spireAgentUrl, authorizedSpiffeIds, httpHost, grpcHost, "TLSv1.3");
    }

    public static ClientImpl spire(String spireAgentUrl, String authorizedSpiffeIds, String httpHost, String grpcHost, String tlsProtocol) throws SpiffeX509SourceProviderException, KeyManagementException, SSLException, NoSuchAlgorithmException {
        SpireX509Client x509Client = new SpireX509Client.SpireX509ClientBuilder().setSpireAgentURL(spireAgentUrl).setAuthorizedSpiffeIds(authorizedSpiffeIds, ',').build();
        OkHttpClient httpClient = new OkHttpClient.Builder().sslSocketFactory(x509Client.getHttpSSLContextForMtls(tlsProtocol).getSocketFactory(), (X509TrustManager)x509Client.getTrustManager()).hostnameVerifier((hostname, session) -> true).build();
        ManagedChannel managedChannel = grpcHost == null ? null : NettyChannelBuilder.forTarget((String)grpcHost).sslContext(x509Client.getGrpcClientSslContextForMtls()).build();
        return new ClientImpl(httpHost, httpClient, managedChannel);
    }

    public ClientImpl(String httpHost, String grpcHost) {
        this(httpHost, new OkHttpClient.Builder().build(), grpcHost == null ? null : ManagedChannelBuilder.forTarget((String)grpcHost).defaultLoadBalancingPolicy("round_robin").usePlaintext().build());
    }

    public ClientImpl(String httpHost, OkHttpClient httpClient, ManagedChannel channel) {
        this.httpHost = Objects.requireNonNull(httpHost);
        this.httpClient = httpClient.newBuilder().addInterceptor((Interceptor)new UserAgentInterceptor()).build();
        this.channel = channel;
        this.userAgent = DEFAULT_USER_AGENT;
    }

    private static String resolveHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            String hostname = System.getenv("HOSTNAME");
            return hostname != null ? hostname : "unknown";
        }
    }

    private static String buildUserAgent() {
        String client = "java-client";
        String version = ClientImpl.class.getPackage().getImplementationVersion() != null ? ClientImpl.class.getPackage().getImplementationVersion() : "unknown";
        String operatingSystem = System.getProperty("os.name", "unknown");
        String arch = System.getProperty("os.arch", "unknown");
        String commit = System.getProperty("commit.hash", "unknown");
        String hostname = ClientImpl.resolveHostname();
        String user = System.getProperty("user.name", "unknown");
        return String.format("%s/%s (%s/%s) cc/%s hostname/%s user/%s", client, version, operatingSystem, arch, commit, hostname, user);
    }

    @Override
    public <T extends HasMetadata> GetRequest<T> get(ObjectIdentifier<T> objectIdentifier) {
        return new GetRequest<T>(this.httpHost, this.httpClient, objectIdentifier);
    }

    @Override
    public <T extends HasMetadata> CreateRequest<T> create(T obj) {
        if (obj instanceof Adapter) {
            Adapter adapter = (Adapter)obj;
            return new CreateRequest<Adapter>(this.httpHost, this.httpClient, adapter);
        }
        return new CreateRequest<T>(this.httpHost, this.httpClient, obj);
    }

    @Override
    public <T extends HasMetadata> DeleteRequest<T> delete(ObjectIdentifier<T> objectIdentifier) {
        return new DeleteRequest<T>(this.httpHost, this.httpClient, objectIdentifier);
    }

    @Override
    public <T extends HasMetadata> UpdateRequest<T> update(T obj) {
        if (obj instanceof Adapter) {
            Adapter adapter = (Adapter)obj;
            return new UpdateRequest<Adapter>(this.httpHost, this.httpClient, adapter);
        }
        return new UpdateRequest<T>(this.httpHost, this.httpClient, obj);
    }

    @Override
    public <T extends HasMetadata> ListRequest<T> list(Class<T> objClass) {
        return new ListRequest<T>(this.httpHost, this.httpClient, objClass);
    }

    @Override
    public <T extends HasMetadata> Watcher<T> watch(Class<T> objClass) {
        return new Watcher<T>((Channel)this.channel, objClass);
    }

    @Override
    public <U, V extends Adapter<U>> Watcher<V> watch(V adapter) {
        return Watcher.fromAdapter((Channel)this.channel, adapter);
    }

    @Override
    public <U, V extends Adapter<U>> ListRequest<V> list(V adapter) {
        return ListRequest.fromAdapter(this.httpHost, this.httpClient, adapter);
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    @Generated
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    private class UserAgentInterceptor
    implements Interceptor {
        private UserAgentInterceptor() {
        }

        @Nonnull
        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request originalRequest = chain.request();
            Request requestWithUserAgent = originalRequest.newBuilder().header(ClientImpl.USER_AGENT_HEADER, ClientImpl.this.getUserAgent()).build();
            return chain.proceed(requestWithUserAgent);
        }
    }
}

