/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.generated.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.confluent.resourcemanager.api.generated.model.ApisMetaV1EnvironmentLocalObjectReference;
import io.confluent.resourcemanager.api.generated.model.FlinkV1ScalingStatus;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@JsonPropertyOrder(value={"deploymentRef", "detail", "flinkJobState", "jobId", "latestOffsets", "latestOffsetsTimestamp", "phase", "restService", "scalingStatus"})
public class SqlV3SQLJobStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String JSON_PROPERTY_DEPLOYMENT_REF = "deploymentRef";
    private ApisMetaV1EnvironmentLocalObjectReference deploymentRef;
    public static final String JSON_PROPERTY_DETAIL = "detail";
    private String detail;
    public static final String JSON_PROPERTY_FLINK_JOB_STATE = "flinkJobState";
    private FlinkJobStateEnum flinkJobState;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    private String jobId;
    public static final String JSON_PROPERTY_LATEST_OFFSETS = "latestOffsets";
    private Map<String, String> latestOffsets = new HashMap<String, String>();
    public static final String JSON_PROPERTY_LATEST_OFFSETS_TIMESTAMP = "latestOffsetsTimestamp";
    private OffsetDateTime latestOffsetsTimestamp;
    public static final String JSON_PROPERTY_PHASE = "phase";
    private PhaseEnum phase;
    public static final String JSON_PROPERTY_REST_SERVICE = "restService";
    private String restService;
    public static final String JSON_PROPERTY_SCALING_STATUS = "scalingStatus";
    private FlinkV1ScalingStatus scalingStatus;
    private Map<String, Object> additionalProperties;

    public SqlV3SQLJobStatus deploymentRef(ApisMetaV1EnvironmentLocalObjectReference deploymentRef) {
        this.deploymentRef = deploymentRef;
        return this;
    }

    @Nullable
    @JsonProperty(value="deploymentRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public ApisMetaV1EnvironmentLocalObjectReference getDeploymentRef() {
        return this.deploymentRef;
    }

    @JsonProperty(value="deploymentRef")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDeploymentRef(ApisMetaV1EnvironmentLocalObjectReference deploymentRef) {
        this.deploymentRef = deploymentRef;
    }

    public SqlV3SQLJobStatus detail(String detail) {
        this.detail = detail;
        return this;
    }

    @Nullable
    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getDetail() {
        return this.detail;
    }

    @JsonProperty(value="detail")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setDetail(String detail) {
        this.detail = detail;
    }

    public SqlV3SQLJobStatus flinkJobState(FlinkJobStateEnum flinkJobState) {
        this.flinkJobState = flinkJobState;
        return this;
    }

    @Nullable
    @JsonProperty(value="flinkJobState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FlinkJobStateEnum getFlinkJobState() {
        return this.flinkJobState;
    }

    @JsonProperty(value="flinkJobState")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setFlinkJobState(FlinkJobStateEnum flinkJobState) {
        this.flinkJobState = flinkJobState;
    }

    public SqlV3SQLJobStatus jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @Nullable
    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getJobId() {
        return this.jobId;
    }

    @JsonProperty(value="jobId")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public SqlV3SQLJobStatus latestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
        return this;
    }

    public SqlV3SQLJobStatus putLatestOffsetsItem(String key, String latestOffsetsItem) {
        if (this.latestOffsets == null) {
            this.latestOffsets = new HashMap<String, String>();
        }
        this.latestOffsets.put(key, latestOffsetsItem);
        return this;
    }

    @Nullable
    @JsonProperty(value="latestOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public Map<String, String> getLatestOffsets() {
        return this.latestOffsets;
    }

    @JsonProperty(value="latestOffsets")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestOffsets(Map<String, String> latestOffsets) {
        this.latestOffsets = latestOffsets;
    }

    public SqlV3SQLJobStatus latestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
        return this;
    }

    @Nullable
    @JsonProperty(value="latestOffsetsTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public OffsetDateTime getLatestOffsetsTimestamp() {
        return this.latestOffsetsTimestamp;
    }

    @JsonProperty(value="latestOffsetsTimestamp")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setLatestOffsetsTimestamp(OffsetDateTime latestOffsetsTimestamp) {
        this.latestOffsetsTimestamp = latestOffsetsTimestamp;
    }

    public SqlV3SQLJobStatus phase(PhaseEnum phase) {
        this.phase = phase;
        return this;
    }

    @Nullable
    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public PhaseEnum getPhase() {
        return this.phase;
    }

    @JsonProperty(value="phase")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setPhase(PhaseEnum phase) {
        this.phase = phase;
    }

    public SqlV3SQLJobStatus restService(String restService) {
        this.restService = restService;
        return this;
    }

    @Nullable
    @JsonProperty(value="restService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public String getRestService() {
        return this.restService;
    }

    @JsonProperty(value="restService")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setRestService(String restService) {
        this.restService = restService;
    }

    public SqlV3SQLJobStatus scalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
        return this;
    }

    @Nullable
    @JsonProperty(value="scalingStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public FlinkV1ScalingStatus getScalingStatus() {
        return this.scalingStatus;
    }

    @JsonProperty(value="scalingStatus")
    @JsonInclude(value=JsonInclude.Include.USE_DEFAULTS)
    public void setScalingStatus(FlinkV1ScalingStatus scalingStatus) {
        this.scalingStatus = scalingStatus;
    }

    @JsonAnySetter
    public SqlV3SQLJobStatus putAdditionalProperty(String key, Object value) {
        if (this.additionalProperties == null) {
            this.additionalProperties = new HashMap<String, Object>();
        }
        this.additionalProperties.put(key, value);
        return this;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Object getAdditionalProperty(String key) {
        if (this.additionalProperties == null) {
            return null;
        }
        return this.additionalProperties.get(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SqlV3SQLJobStatus sqlV3SQLJobStatus = (SqlV3SQLJobStatus)o;
        return Objects.equals(this.deploymentRef, sqlV3SQLJobStatus.deploymentRef) && Objects.equals(this.detail, sqlV3SQLJobStatus.detail) && Objects.equals((Object)this.flinkJobState, (Object)sqlV3SQLJobStatus.flinkJobState) && Objects.equals(this.jobId, sqlV3SQLJobStatus.jobId) && Objects.equals(this.latestOffsets, sqlV3SQLJobStatus.latestOffsets) && Objects.equals(this.latestOffsetsTimestamp, sqlV3SQLJobStatus.latestOffsetsTimestamp) && Objects.equals((Object)this.phase, (Object)sqlV3SQLJobStatus.phase) && Objects.equals(this.restService, sqlV3SQLJobStatus.restService) && Objects.equals(this.scalingStatus, sqlV3SQLJobStatus.scalingStatus) && Objects.equals(this.additionalProperties, sqlV3SQLJobStatus.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.deploymentRef, this.detail, this.flinkJobState, this.jobId, this.latestOffsets, this.latestOffsetsTimestamp, this.phase, this.restService, this.scalingStatus, super.hashCode(), this.additionalProperties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SqlV3SQLJobStatus {\n");
        sb.append("    ").append(this.toIndentedString(super.toString())).append("\n");
        sb.append("    deploymentRef: ").append(this.toIndentedString(this.deploymentRef)).append("\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        sb.append("    flinkJobState: ").append(this.toIndentedString((Object)this.flinkJobState)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString(this.jobId)).append("\n");
        sb.append("    latestOffsets: ").append(this.toIndentedString(this.latestOffsets)).append("\n");
        sb.append("    latestOffsetsTimestamp: ").append(this.toIndentedString(this.latestOffsetsTimestamp)).append("\n");
        sb.append("    phase: ").append(this.toIndentedString((Object)this.phase)).append("\n");
        sb.append("    restService: ").append(this.toIndentedString(this.restService)).append("\n");
        sb.append("    scalingStatus: ").append(this.toIndentedString(this.scalingStatus)).append("\n");
        sb.append("    additionalProperties: ").append(this.toIndentedString(this.additionalProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum FlinkJobStateEnum {
        CANCELED("Canceled"),
        CANCELLING("Cancelling"),
        CREATED("Created"),
        FAILED("Failed"),
        FAILING("Failing"),
        FINISHED("Finished"),
        INITIALIZING("Initializing"),
        RECONCILING("Reconciling"),
        RESTARTING("Restarting"),
        RUNNING("Running"),
        SUSPENDED("Suspended");

        private String value;

        private FlinkJobStateEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static FlinkJobStateEnum fromValue(String value) {
            for (FlinkJobStateEnum b : FlinkJobStateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }

    public static enum PhaseEnum {
        COMPLETED("Completed"),
        DEGRADED("Degraded"),
        DELETING("Deleting"),
        FAILED("Failed"),
        PENDING("Pending"),
        READY("Ready"),
        RESUMING("Resuming"),
        STOPPED("Stopped"),
        STOPPING("Stopping");

        private String value;

        private PhaseEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static PhaseEnum fromValue(String value) {
            for (PhaseEnum b : PhaseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

