/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.resourcemanager.api.model.identifier;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.confluent.resourcemanager.api.client.GroupVersionResource;
import io.confluent.resourcemanager.api.model.HasMetadata;
import io.confluent.resourcemanager.api.model.location.Location;
import io.confluent.resourcemanager.api.model.scope.Scoping;
import io.confluent.resourcemanager.protobuf.apis.meta.v1.ScopeAttribute;
import java.util.List;
import lombok.Generated;

public class ObjectIdentifier<T extends HasMetadata> {
    private final GroupVersionResource groupVersionResource;
    private final String kind;
    private final Scoping scoping;
    private final Location location;
    private final List<ScopeAttribute> scope;
    private final String name;
    private final JavaType javaType;

    public ObjectIdentifier(Location location, Scoping scoping, List<ScopeAttribute> scope, String name, Class<?> clazz) {
        this.groupVersionResource = HasMetadata.getGVR(clazz).orElseThrow();
        this.location = location;
        this.scoping = scoping;
        this.scope = scope;
        this.name = name;
        this.javaType = TypeFactory.defaultInstance().constructType(clazz);
        this.kind = HasMetadata.getKind(clazz);
    }

    public ObjectIdentifier(GroupVersionResource groupVersionResource, String kind, Scoping scoping, Location location, List<ScopeAttribute> scope, String name, JavaType javaType) {
        this.groupVersionResource = groupVersionResource;
        this.kind = kind;
        this.location = location;
        this.scoping = scoping;
        this.scope = scope;
        this.name = name;
        this.javaType = javaType;
    }

    public static <T extends HasMetadata> ObjectIdentifier<T> of(Location location, Scoping scoping, List<ScopeAttribute> scope, String name, Class<?> clazz) {
        return new ObjectIdentifier<T>(location, scoping, scope, name, clazz);
    }

    @Generated
    public GroupVersionResource getGroupVersionResource() {
        return this.groupVersionResource;
    }

    @Generated
    public String getKind() {
        return this.kind;
    }

    @Generated
    public Scoping getScoping() {
        return this.scoping;
    }

    @Generated
    public Location getLocation() {
        return this.location;
    }

    @Generated
    public List<ScopeAttribute> getScope() {
        return this.scope;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public JavaType getJavaType() {
        return this.javaType;
    }
}

