/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.SaslConfigs;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.security.auth.SecurityProtocol;

public class KafkaConfigs {
    public static final String SRC_CONSUMER_PREFIX = "src.consumer.";
    public static final String DEST_CONSUMER_PREFIX = "dest.consumer.";
    private static final Map<String, ConfigDef.ConfigKey> ALL_CONSUMER_CONFIGS;

    public static void addDefinitions(ConfigDef configDef) {
        KafkaConfigs.defineShared(configDef, KafkaCluster.SOURCE, false);
        KafkaConfigs.defineSharedSecurity(configDef, KafkaCluster.SOURCE);
        KafkaConfigs.defineSharedSecurity(configDef, KafkaCluster.DESTINATION);
        KafkaConfigs.defineConsumer(configDef);
        KafkaConfigs.defineShared(configDef, KafkaCluster.DESTINATION, true);
    }

    private static void defineShared(ConfigDef configDef, KafkaCluster kafka, boolean optional) {
        String group = kafka.toString() + " Kafka";
        int orderInGroup = 0;
        KafkaConfigs.define(configDef, kafka.prefix(), optional ? "" : null, KafkaConfigs.baseConfigKey("bootstrap.servers"), group, ++orderInGroup, ConfigDef.Width.NONE, null, null);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("client.id"), group, ++orderInGroup, ConfigDef.Width.NONE);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("request.timeout.ms"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("retry.backoff.ms"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("connections.max.idle.ms"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("reconnect.backoff.ms"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("metric.reporters"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("metrics.num.samples"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("metrics.sample.window.ms"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("send.buffer.bytes"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, kafka.prefix(), KafkaConfigs.baseConfigKey("receive.buffer.bytes"), group, ++orderInGroup, ConfigDef.Width.MEDIUM);
    }

    private static void defineSharedSecurity(ConfigDef configDef, KafkaCluster kafka) {
        String group = kafka.toString() + " Kafka: Security";
        int orderInGroup = 0;
        KafkaConfigs.define(configDef, kafka.prefix(), null, KafkaConfigs.baseConfigKey("security.protocol"), group, ++orderInGroup, ConfigDef.Width.NONE, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])SecurityProtocolRecommender.VALID_VALUES.toArray(new String[SecurityProtocolRecommender.VALID_VALUES.size()])), new SecurityProtocolRecommender());
        SecurityProtocolSpecificRecommender saslRecommender = new SecurityProtocolSpecificRecommender(kafka.prefix() + "security.protocol", SecurityProtocol.SASL_PLAINTEXT, SecurityProtocol.SASL_SSL);
        for (ConfigDef.ConfigKey saslConfigKey : KafkaConfigs.saslConfigs().values()) {
            KafkaConfigs.define(configDef, kafka.prefix(), null, saslConfigKey, group, ++orderInGroup, ConfigDef.Width.NONE, null, saslRecommender);
        }
        SecurityProtocolSpecificRecommender sslRecommender = new SecurityProtocolSpecificRecommender(kafka.prefix() + "security.protocol", SecurityProtocol.SASL_SSL, SecurityProtocol.SSL);
        for (ConfigDef.ConfigKey sslConfigKey : KafkaConfigs.sslConfigs().values()) {
            KafkaConfigs.define(configDef, kafka.prefix(), null, sslConfigKey, group, ++orderInGroup, ConfigDef.Width.NONE, null, sslRecommender);
        }
    }

    private static void defineConsumer(ConfigDef configDef) {
        String group = "Source Kafka: Consumer";
        int orderInGroup = 0;
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("interceptor.classes"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.NONE);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("fetch.max.wait.ms"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("fetch.min.bytes"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("fetch.max.bytes"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("max.partition.fetch.bytes"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("max.poll.interval.ms"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("max.poll.records"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.MEDIUM);
        KafkaConfigs.define(configDef, SRC_CONSUMER_PREFIX, KafkaConfigs.baseConfigKey("check.crcs"), "Source Kafka: Consumer", ++orderInGroup, ConfigDef.Width.NONE);
    }

    private static ConfigDef.ConfigKey baseConfigKey(String key) {
        return ALL_CONSUMER_CONFIGS.get(key);
    }

    private static void define(ConfigDef configDef, String prefix, ConfigDef.ConfigKey baseConfigKey, String group, int orderInGroup, ConfigDef.Width width) {
        KafkaConfigs.define(configDef, prefix, null, baseConfigKey, group, orderInGroup, width, null, null);
    }

    private static void define(ConfigDef configDef, String prefix, Object defaultValueOverride, ConfigDef.ConfigKey baseConfigKey, String group, int orderInGroup, ConfigDef.Width width, ConfigDef.Validator validator, ConfigDef.Recommender recommender) {
        configDef.define(prefix + baseConfigKey.name, baseConfigKey.type, defaultValueOverride == null ? baseConfigKey.defaultValue : defaultValueOverride, validator != null ? validator : baseConfigKey.validator, baseConfigKey.importance, KafkaConfigs.htmlToRst(baseConfigKey.documentation), group, orderInGroup, width, ".." + baseConfigKey.name, recommender);
    }

    private static Map<String, ConfigDef.ConfigKey> sslConfigs() {
        ConfigDef cfg = new ConfigDef();
        SslConfigs.addClientSslSupport((ConfigDef)cfg);
        return cfg.configKeys();
    }

    private static Map<String, ConfigDef.ConfigKey> saslConfigs() {
        ConfigDef cfg = new ConfigDef();
        SaslConfigs.addClientSaslSupport((ConfigDef)cfg);
        return cfg.configKeys();
    }

    private static String htmlToRst(String html) {
        return html.trim().replace("<code>", "``").replace("</code>", "``").replace("&mdash;", " \u2014 ");
    }

    static {
        try {
            Field configField = ConsumerConfig.class.getDeclaredField("CONFIG");
            configField.setAccessible(true);
            ConfigDef consumerConfigDef = (ConfigDef)configField.get(ConsumerConfig.class);
            ALL_CONSUMER_CONFIGS = new TreeMap<String, ConfigDef.ConfigKey>(consumerConfigDef.configKeys());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum KafkaCluster {
        SOURCE("Source", "src.kafka."),
        DESTINATION("Destination", "dest.kafka.");

        private final String type;
        private final String prefix;

        private KafkaCluster(String type, String prefix) {
            this.type = type;
            this.prefix = prefix;
        }

        public String toString() {
            return this.type;
        }

        public String prefix() {
            return this.prefix;
        }

        public String bootstrapServersConfig() {
            return this.prefix + "bootstrap.servers";
        }
    }

    private static class SecurityProtocolRecommender
    implements ConfigDef.Recommender {
        static final List<Object> VALID_VALUES = new ArrayList<Object>();

        private SecurityProtocolRecommender() {
        }

        public List<Object> validValues(String s, Map<String, Object> map) {
            return VALID_VALUES;
        }

        public boolean visible(String s, Map<String, Object> map) {
            return true;
        }

        static {
            for (SecurityProtocol protocol : SecurityProtocol.values()) {
                VALID_VALUES.add(protocol.name());
            }
        }
    }

    private static class SecurityProtocolSpecificRecommender
    implements ConfigDef.Recommender {
        private final String configKey;
        private final Set<String> protocolNames;

        SecurityProtocolSpecificRecommender(String configKey, SecurityProtocol ... protocols) {
            this.configKey = configKey;
            this.protocolNames = new HashSet<String>(protocols.length);
            for (SecurityProtocol protocol : protocols) {
                this.protocolNames.add(protocol.name());
            }
        }

        public List<Object> validValues(String s, Map<String, Object> map) {
            return Collections.emptyList();
        }

        public boolean visible(String s, Map<String, Object> map) {
            return this.protocolNames.contains(map.get(this.configKey));
        }
    }
}

