/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.license.License;
import io.confluent.license.kafka.BrokerDetector;
import io.confluent.license.kafka.BrokerType;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicenseSelectionStrategy {
    private static final Logger log = LoggerFactory.getLogger(LicenseSelectionStrategy.class);
    private final BrokerType sourceType;
    private final BrokerType destType;
    public static final String INVALID_LICENSE_ERROR_MESSAGE = "Your license for Customer-Managed Confluent Platform for Confluent Cloud may be used solely to access and use the Cloud Service. When operating under this specific license, Confluent does not provide support for any self-managed (Confluent Platform) components utilised exclusively for Confluent Platform broker use cases. To be eligible for support, you must ensure you are connecting to a Confluent Cloud broker or are utilizing a valid Enterprise license for a Confluent Platform subscription.";

    public LicenseSelectionStrategy(Map<String, Object> sourceConfig, Map<String, Object> destConfig) {
        this(sourceConfig, destConfig, BrokerDetector.create());
    }

    public LicenseSelectionStrategy(Map<String, Object> sourceConfig, Map<String, Object> destConfig, BrokerDetector detector) {
        this.sourceType = detector.determineBrokerType(sourceConfig);
        this.destType = detector.determineBrokerType(destConfig);
        log.info("Initialized LicenseSelectionStrategy with source broker type: {}, destination broker type: {}", (Object)this.sourceType, (Object)this.destType);
    }

    public License selectBestLicense(List<License> licenses) {
        if (licenses == null || licenses.isEmpty()) {
            log.warn("No licenses available for selection");
            return null;
        }
        return this.selectLicenseForBrokerTypes(licenses, this.sourceType, this.destType);
    }

    private License selectLicenseForBrokerTypes(List<License> licenses, BrokerType sourceType, BrokerType destType) {
        boolean hasCloudBroker = sourceType == BrokerType.CONFLUENT_CLOUD || destType == BrokerType.CONFLUENT_CLOUD;
        log.debug("Source broker type is {}, destination broker type is {}.", (Object)sourceType, (Object)destType);
        License cpForCcLicense = null;
        License cpLicense = null;
        for (License license : licenses) {
            if (license.deploymentScope() == License.DeploymentScope.CP_FOR_CC) {
                log.trace("Found a CP for CC license: {}", (Object)license);
                cpForCcLicense = license;
                continue;
            }
            if (license.deploymentScope() != License.DeploymentScope.CP) continue;
            log.trace("Found a CP license: {}", (Object)license);
            cpLicense = license;
        }
        if (hasCloudBroker) {
            log.trace("At least one of the brokers is CCloud, so a CP for CC license is preferred if one exists. Checking the license types");
            License preferredCCLicense = this.selectPreferredCCLicense(cpLicense, cpForCcLicense);
            if (preferredCCLicense != null) {
                return preferredCCLicense;
            }
        } else {
            log.trace("None of the brokers are CCloud, so CP for CC license is not allowed. Checking for a CP license.");
            if (cpLicense != null) {
                log.info("Selected CP license for on-prem configuration: {}", (Object)cpLicense.licenseId());
                return cpLicense;
            }
        }
        log.debug("LicenseSelectionStrategy did not find a suitable license type for these brokers.");
        return null;
    }

    private License selectPreferredCCLicense(License cpLicense, License cpForCcLicense) {
        if (cpForCcLicense != null && cpForCcLicense.isValid() && !cpForCcLicense.isExpired()) {
            log.info("Selected CP_FOR_CC license for Confluent Cloud configuration: {}", (Object)cpForCcLicense.licenseId());
            return cpForCcLicense;
        }
        if (cpLicense != null) {
            log.info("Selected CP license as fallback for Confluent Cloud configuration: {}", (Object)cpLicense.licenseId());
            return cpLicense;
        }
        return null;
    }
}

