/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator;

import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import io.confluent.connect.replicator.TopicMonitorThread;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.clients.admin.TopicListing;
import org.apache.kafka.clients.consumer.ConsumerPartitionAssignor;
import org.apache.kafka.clients.consumer.RoundRobinAssignor;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.WakeupException;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.apache.kafka.connect.errors.ConnectException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewTopicMonitorThread
extends Thread
implements TopicMonitorThread {
    private static final Logger log = LoggerFactory.getLogger(NewTopicMonitorThread.class);
    private static final int MAX_THREAD_JOIN_TIME_MS = 5000;
    private final ConnectorContext context;
    private final AdminClient adminClient;
    private final Set<String> whitelistTopics;
    private final Pattern topicPattern;
    private final Set<String> blacklistTopics;
    private final String connectorName;
    private final long pollIntervalMs;
    private final int translatorTasksMax;
    private final boolean translatorTasksSeparate;
    private final boolean hasDestBootstrapServers;
    private final ConsumerPartitionAssignor assignor;
    private final CountDownLatch firstRefreshLatch;
    private final CountDownLatch shutdownLatch;
    private volatile Map<String, List<PartitionInfo>> currentTopics = null;

    public NewTopicMonitorThread(ConnectorContext context, ReplicatorSourceConnectorConfig config) {
        this(context, config.getName(), config.getTopics(), config.getTopicPattern(), config.getBlacklistTopics(), config.getTopicPollIntervalMs(), config.getOffsetTranslatorTasksMax(), config.areOffsetTranslatorTasksSeparate(), config.getList(KafkaConfigs.KafkaCluster.DESTINATION.bootstrapServersConfig()), AdminClient.create(config.srcAdminClientConfig()));
    }

    protected NewTopicMonitorThread(ConnectorContext context, String connectorName, Set<String> whitelistTopics, Pattern topicPattern, Set<String> blacklistTopics, long pollIntervalMs, int translatorTasksMax, boolean translatorTasksSeparate, List<String> destBootstrapServers, AdminClient adminClient) {
        this(context, connectorName, whitelistTopics, topicPattern, blacklistTopics, pollIntervalMs, translatorTasksMax, translatorTasksSeparate, destBootstrapServers, adminClient, (ConsumerPartitionAssignor)new RoundRobinAssignor(), new CountDownLatch(1), new CountDownLatch(1));
    }

    protected NewTopicMonitorThread(ConnectorContext context, String connectorName, Set<String> whitelistTopics, Pattern topicPattern, Set<String> blacklistTopics, long pollIntervalMs, int translatorTasksMax, boolean translatorTasksSeparate, List<String> destBootstrapServers, AdminClient adminClient, ConsumerPartitionAssignor assignor, CountDownLatch firstRefreshLatch, CountDownLatch shutdownLatch) {
        super("topic-monitor-thread-" + connectorName);
        this.context = context;
        this.whitelistTopics = whitelistTopics;
        this.topicPattern = topicPattern;
        this.blacklistTopics = blacklistTopics;
        this.connectorName = connectorName;
        this.pollIntervalMs = pollIntervalMs;
        this.translatorTasksMax = translatorTasksMax;
        this.translatorTasksSeparate = translatorTasksSeparate;
        this.hasDestBootstrapServers = destBootstrapServers != null && destBootstrapServers.size() > 0;
        this.adminClient = adminClient;
        this.assignor = assignor;
        this.firstRefreshLatch = firstRefreshLatch;
        this.shutdownLatch = shutdownLatch;
    }

    @Override
    public Map<String, ConsumerPartitionAssignor.Assignment> assignments(int maxTasks) {
        log.info("Assigning topic partitions to {} tasks...", (Object)maxTasks);
        if (!this.hasDestBootstrapServers) {
            log.warn("Offset translation will NOT be performed because '" + KafkaConfigs.KafkaCluster.DESTINATION.bootstrapServersConfig() + "' is not defined in the Replicator configuration.  To enable offset translation, add '" + KafkaConfigs.KafkaCluster.DESTINATION.bootstrapServersConfig() + "' to the configuration and restart Replicator.");
        }
        if (this.currentTopics == null) {
            try {
                this.firstRefreshLatch.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.currentTopics == null) {
            throw new ConnectException("Could not obtain timely topic metadata update from source cluster");
        }
        Map<String, List<PartitionInfo>> currentTopicsSnapshot = this.currentTopics;
        if (currentTopicsSnapshot.isEmpty()) {
            return Collections.emptyMap();
        }
        Cluster cluster = this.buildCluster(currentTopicsSnapshot);
        Map<String, ConsumerPartitionAssignor.Subscription> subscriptions = this.buildSubscriptions(currentTopicsSnapshot, maxTasks);
        Map assignments = this.assignor.assign(cluster, new ConsumerPartitionAssignor.GroupSubscription(subscriptions)).groupAssignment();
        log.info("Finished computing task topic partition assignments: {}", (Object)assignments);
        return assignments;
    }

    private int numTranslationPartitionsToAssign(Map<String, List<PartitionInfo>> currentTopicsSnapshot) {
        return currentTopicsSnapshot.getOrDefault("__consumer_timestamps", Collections.emptyList()).size();
    }

    private int numReplicatedPartitionsToAssign(Map<String, List<PartitionInfo>> currentTopicsSnapshot) {
        int numPartitions = 0;
        for (Map.Entry<String, List<PartitionInfo>> entry : currentTopicsSnapshot.entrySet()) {
            if (entry.getKey().equals("__consumer_timestamps")) continue;
            numPartitions += entry.getValue().size();
        }
        return numPartitions;
    }

    private Map<String, ConsumerPartitionAssignor.Subscription> buildSubscriptions(Map<String, List<PartitionInfo>> currentTopicsSnapshot, int maxTasks) {
        Set<String> topics = currentTopicsSnapshot.keySet();
        return this.translatorTasksSeparate && topics.contains("__consumer_timestamps") ? this.buildSeparateSubscriptions(currentTopicsSnapshot, maxTasks) : this.buildJointSubscriptions(currentTopicsSnapshot, maxTasks);
    }

    private Map<String, ConsumerPartitionAssignor.Subscription> buildJointSubscriptions(Map<String, List<PartitionInfo>> currentTopicsSnapshot, int maxTasks) {
        assert (this.translatorTasksMax <= maxTasks);
        log.debug("Building subscriptions for Replicator source tasks...");
        Set<String> topics = currentTopicsSnapshot.keySet();
        int numTranslationTasks = Math.min(this.numTranslationPartitionsToAssign(currentTopicsSnapshot), this.translatorTasksMax >= 0 ? this.translatorTasksMax : maxTasks);
        int numReplicationTasks = Math.min(this.numReplicatedPartitionsToAssign(currentTopicsSnapshot), maxTasks);
        int numTasks = Math.min(numTranslationTasks + numReplicationTasks, maxTasks);
        ArrayList<String> allTopics = new ArrayList<String>(topics);
        List<String> topicsWithoutTsTopic = this.topicsWithoutTimestampsTopic(topics);
        HashMap<String, ConsumerPartitionAssignor.Subscription> subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            String taskId = this.connectorName + "-" + i;
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(i < numTasks - numTranslationTasks ? topicsWithoutTsTopic : allTopics);
            subscriptions.put(taskId, subscription);
        }
        log.debug("Finished building subscriptions for Replicator source tasks.");
        return subscriptions;
    }

    private Map<String, ConsumerPartitionAssignor.Subscription> buildSeparateSubscriptions(Map<String, List<PartitionInfo>> currentTopicsSnapshot, int maxTasks) {
        assert (this.translatorTasksMax >= 0 && this.translatorTasksMax < maxTasks);
        log.debug("Building separate subscriptions for offset translation tasks and Replicator tasks...");
        Set<String> topics = currentTopicsSnapshot.keySet();
        int numTranslationTasks = Math.min(this.numTranslationPartitionsToAssign(currentTopicsSnapshot), this.translatorTasksMax);
        int numReplicationTasks = Math.min(this.numReplicatedPartitionsToAssign(currentTopicsSnapshot), maxTasks - numTranslationTasks);
        int numTasks = numTranslationTasks + numReplicationTasks;
        List<String> topicsWithoutTimestampsTopic = this.topicsWithoutTimestampsTopic(topics);
        List<String> consumerTimestampsTopic = Collections.singletonList("__consumer_timestamps");
        HashMap<String, ConsumerPartitionAssignor.Subscription> subscriptions = new HashMap<String, ConsumerPartitionAssignor.Subscription>(numTasks);
        for (int i = 0; i < numTasks; ++i) {
            String taskId = this.connectorName + "-" + i;
            ConsumerPartitionAssignor.Subscription subscription = new ConsumerPartitionAssignor.Subscription(i < numTasks - numTranslationTasks ? topicsWithoutTimestampsTopic : consumerTimestampsTopic);
            subscriptions.put(taskId, subscription);
        }
        log.debug("Finished building separate subscriptions for offset translation tasks and Replicator tasks");
        return subscriptions;
    }

    private List<String> topicsWithoutTimestampsTopic(Set<String> topics) {
        return topics.stream().filter(t -> !t.equals("__consumer_timestamps")).collect(Collectors.toList());
    }

    private Cluster buildCluster(Map<String, List<PartitionInfo>> currentTopicsSnapshot) {
        HashSet nodes = new HashSet();
        ArrayList matchingPartitionInfo = new ArrayList();
        for (Map.Entry<String, List<PartitionInfo>> topicEntry : currentTopicsSnapshot.entrySet()) {
            matchingPartitionInfo.addAll(topicEntry.getValue());
            for (PartitionInfo partitionInfo : topicEntry.getValue()) {
                Collections.addAll(nodes, partitionInfo.replicas());
            }
        }
        return new Cluster(null, nodes, matchingPartitionInfo, Collections.emptySet(), Collections.emptySet());
    }

    private boolean matchesTopicPattern(String topic) {
        if (topic.length() > 1000) {
            throw new InvalidConfigurationException("Topic length is too long; it must be less than 1000 characters.");
        }
        return this.topicPattern != null && this.topicPattern.matcher(topic).matches();
    }

    private Map<String, List<PartitionInfo>> listMatchingTopics() throws InterruptedException, ExecutionException {
        Collection topicListings = (Collection)this.maybeListTopics().get();
        HashSet<String> matchingTopics = new HashSet<String>();
        for (Object topicListing : topicListings) {
            if (!this.shouldAddTopic((TopicListing)topicListing)) continue;
            matchingTopics.add(topicListing.name());
        }
        log.info("Found matching topics: {}", matchingTopics);
        ArrayList<String> missingWhitelistTopics = new ArrayList<String>();
        for (String whiteListedTopic : this.whitelistTopics) {
            if (matchingTopics.contains(whiteListedTopic)) continue;
            missingWhitelistTopics.add(whiteListedTopic);
        }
        if (!missingWhitelistTopics.isEmpty()) {
            throw new InvalidConfigurationException("topic.whitelist contains topics: " + String.valueOf(missingWhitelistTopics) + " but these are either not present in the source cluster or are missing DESCRIBE ACLs. Please make sure that the topics are allowed to DESCRIBE in ACLs");
        }
        if (this.topicPattern != null) {
            log.info("topic.regex is set. Replicator requires a DESCRIBE ACL on topics to match via regex. If this ACL is not present then the topic will not be replicated.");
        }
        if (matchingTopics.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, TopicDescription> topicDescriptions = this.maybeDescribeTopics(matchingTopics);
        return this.topicDescriptionsToMetadata(topicDescriptions);
    }

    private boolean shouldAddTopic(TopicListing topicListing) {
        String topic = topicListing.name();
        if (this.hasDestBootstrapServers && topic.equals("__consumer_timestamps")) {
            return true;
        }
        if (this.blacklistTopics.contains(topic)) {
            return false;
        }
        return this.whitelistTopics.contains(topic) || !topicListing.isInternal() && this.matchesTopicPattern(topic);
    }

    private Map<String, List<PartitionInfo>> topicDescriptionsToMetadata(Map<String, TopicDescription> topicDescriptions) {
        HashMap<String, List<PartitionInfo>> topicMetadata = new HashMap<String, List<PartitionInfo>>();
        for (TopicDescription desc : topicDescriptions.values()) {
            List topicPartitionInfos = desc.partitions();
            ArrayList<PartitionInfo> partitionInfos = new ArrayList<PartitionInfo>(topicPartitionInfos.size());
            String topic = desc.name();
            for (TopicPartitionInfo info : topicPartitionInfos) {
                partitionInfos.add(new PartitionInfo(topic, info.partition(), info.leader(), info.replicas().toArray(new Node[info.replicas().size()]), info.isr().toArray(new Node[info.replicas().size()])));
            }
            topicMetadata.put(topic, partitionInfos);
        }
        return topicMetadata;
    }

    private KafkaFuture<Collection<TopicListing>> maybeListTopics() throws InterruptedException {
        if (this.shutdownLatch.getCount() == 0L) {
            throw new CancellationException();
        }
        return this.adminClient.listTopics().listings();
    }

    private Map<String, TopicDescription> maybeDescribeTopics(Set<String> matchingTopics) throws InterruptedException, ExecutionException {
        if (this.shutdownLatch.getCount() == 0L) {
            throw new CancellationException();
        }
        HashMap<String, TopicDescription> topicDescriptions = new HashMap<String, TopicDescription>();
        for (Map.Entry topicDescriptionEntry : this.adminClient.describeTopics(matchingTopics).topicNameValues().entrySet()) {
            try {
                topicDescriptions.put((String)topicDescriptionEntry.getKey(), (TopicDescription)((KafkaFuture)topicDescriptionEntry.getValue()).get());
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof UnknownTopicOrPartitionException)) {
                    log.warn("Unable to describe topic {}. Please make sure that the topic is allowed to DESCRIBE in ACLs at the source cluster. this topic will be ignored until the next refresh", topicDescriptionEntry.getKey());
                    throw e;
                }
                log.trace("Received UnknownTopicOrPartitionException when attempting to describe topic {}. This is expected to be transient and will be resolved in subsequent metadata updates.", (Throwable)e);
            }
        }
        return topicDescriptions;
    }

    private boolean matchesPartitions(Map<String, List<PartitionInfo>> topicMetadataA, Map<String, List<PartitionInfo>> topicMetadataB) {
        if (topicMetadataA.size() != topicMetadataB.size()) {
            return false;
        }
        for (Map.Entry<String, List<PartitionInfo>> topicEntry : topicMetadataA.entrySet()) {
            List<PartitionInfo> oldMetadata = topicMetadataB.get(topicEntry.getKey());
            List<PartitionInfo> newMetadata = topicEntry.getValue();
            if (oldMetadata != null && newMetadata.size() == oldMetadata.size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void start() {
        log.debug("Starting topic monitor thread...");
        super.setDaemon(true);
        super.start();
    }

    @Override
    public void shutdown() {
        this.shutdownLatch.countDown();
        log.debug("Closing topic monitor thread...");
        this.adminClient.close(Duration.ofMillis(0L));
        try {
            super.join(5000L);
            if (super.isAlive()) {
                log.warn("Failed to shutdown topic monitor thread for connector {}", (Object)this.connectorName);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void run() {
        while (this.shutdownLatch.getCount() != 0L) {
            try {
                Map<String, List<PartitionInfo>> updatedTopics = this.listMatchingTopics();
                Map<String, List<PartitionInfo>> currentTopicsSnapshot = this.currentTopics;
                this.currentTopics = updatedTopics;
                if (currentTopicsSnapshot == null) {
                    this.firstRefreshLatch.countDown();
                } else if (!this.matchesPartitions(currentTopicsSnapshot, updatedTopics)) {
                    log.debug("Requesting task reconfiguration...");
                    this.context.requestTaskReconfiguration();
                }
                this.shutdownLatch.await(this.pollIntervalMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn("Failed refreshing topic metadata from the source cluster: ", e);
                try {
                    log.warn("Retrying metadata refresh after {}ms", (Object)this.pollIntervalMs);
                    this.shutdownLatch.await(this.pollIntervalMs, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException ie) {
                    log.warn("Retrying metadata refresh immediately");
                }
            }
            catch (CancellationException | WakeupException e) {
                log.debug("Topic monitor thread woken up for shutdown");
                return;
            }
            catch (Exception e) {
                log.error("Unexpected exception in topic monitor thread", (Throwable)e);
                this.context.raiseError(e);
                return;
            }
        }
    }
}

