/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.config;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.kafka.connect.cli.ConnectDistributed;
import org.apache.kafka.connect.cli.ConnectStandalone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ConnectConfigProvider.class);
    public static final String COMMAND_PROPERTY = "sun.java.command";
    public static final String CONNECT_COMMAND = System.getProperty("sun.java.command");
    public static final String PRODUCER_PREFIX = "producer.";

    private Properties getConnectProperties() {
        if (CONNECT_COMMAND == null || CONNECT_COMMAND.isEmpty()) {
            log.debug("Cannot determine Connect Worker properties from launch command. dest.kafka.* must be set in Replicator configuration");
            return new Properties();
        }
        String[] commandArgs = CONNECT_COMMAND.split(" ");
        if (commandArgs.length <= 1 || !commandArgs[0].equals(ConnectDistributed.class.getName()) && !commandArgs[0].equals(ConnectStandalone.class.getName())) {
            log.debug("Connect Worker properties not provided. dest.kafka.* must be set in Replicator configuration");
            return new Properties();
        }
        Properties props = new Properties();
        try (FileInputStream input = new FileInputStream(commandArgs[1]);){
            props.load(input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return props;
    }

    public Map<String, String> getProducerConfig() {
        Properties connectProperties = this.getConnectProperties();
        HashMap<String, String> prefixConfig = new HashMap<String, String>();
        if (connectProperties.containsKey("bootstrap.servers")) {
            prefixConfig.put("bootstrap.servers", connectProperties.getProperty("bootstrap.servers"));
        }
        connectProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            if (((String)key).startsWith(PRODUCER_PREFIX)) {
                prefixConfig.put(((String)key).substring(PRODUCER_PREFIX.length()), (String)value);
            }
        }));
        log.info("Inferred properties from Connect Worker");
        return prefixConfig;
    }
}

