/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.exec;

import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.connect.runtime.ConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableConfigProvider {
    private static final Logger log = LoggerFactory.getLogger(ExecutableConfigProvider.class);
    private static final String SOURCE_PREFIX = "src.";
    private static final String[] CLIENT_PREFIXES = new String[]{KafkaConfigs.KafkaCluster.DESTINATION.prefix(), KafkaConfigs.KafkaCluster.SOURCE.prefix(), "src.", "src.consumer.", "dest.consumer.", "confluent.topic.", "confluent.topic.consumer.", "confluent.topic.producer.", "transforms"};
    private static final List<String> WORKER_AND_CONNECTOR_PROPERTIES = Arrays.asList("header.converter", "key.converter", "value.converter");
    private Map<String, String> allProps = new HashMap<String, String>();
    private Map<String, String> workerProps = new HashMap<String, String>();
    private Map<String, String> connectorProps = new HashMap<String, String>();

    public Map<String, String> getWorkerConfig() {
        if (this.workerProps == null) {
            this.workerProps = this.allProps.entrySet().stream().filter(x -> !this.isReplicatorProperty((String)x.getKey()) || this.isWorkerAndConnectorProperty((String)x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        if (!this.workerProps.containsKey("plugin.path")) {
            try {
                Path replicatorPath = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath(), new String[0]);
                Path pluginPath = replicatorPath.getParent().getParent();
                this.workerProps.put("plugin.path", pluginPath.toString());
            }
            catch (Exception e) {
                log.warn("Unable to extract '{}' from '{}' location: ", new Object[]{"plugin.path", this.getClass().getName(), e});
            }
        }
        log.debug("Determined Connect worker config {}", this.workerProps);
        return this.workerProps;
    }

    public Map<String, String> getConnectorConfig() {
        if (this.connectorProps == null) {
            this.connectorProps = this.allProps.entrySet().stream().filter(x -> this.isReplicatorProperty((String)x.getKey()) || this.isWorkerAndConnectorProperty((String)x.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        log.debug("Determined Connector config {}", this.connectorProps);
        return this.connectorProps;
    }

    public void setAllProps(Map<String, String> allProps) {
        this.allProps = allProps;
        this.workerProps = null;
        this.connectorProps = null;
    }

    private boolean hasClientPrefix(String propertyName) {
        for (String prefix : CLIENT_PREFIXES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private boolean isReplicatorProperty(String propertyName) {
        return this.hasClientPrefix(propertyName) || ReplicatorSourceConnectorConfig.CONFIG_DEF.names().contains(propertyName) || ConnectorConfig.configDef().names().contains(propertyName);
    }

    private boolean isWorkerAndConnectorProperty(String propertyName) {
        for (String prefix : WORKER_AND_CONNECTOR_PROPERTIES) {
            if (!propertyName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

