/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.offsets;

import io.confluent.connect.replicator.KafkaConfigs;
import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;

public class ConsumerOffsetsTranslatorConfig
extends ReplicatorSourceConnectorConfig {
    private static final String FETCH_OFFSET_EXPIRY_MS_CONFIG = "fetch.offset.expiry.ms";
    private static final long FETCH_OFFSET_EXPIRY_MS_DEFAULT = 600000L;
    private static final String FETCH_OFFSET_EXPIRY_MS_CONFIG_DOC = "The amount of time in milliseconds after which a fetch offset request expires and is then discarded.";
    private static final String FETCH_OFFSET_RETRY_BACKOFF_MS_CONFIG = "fetch.offset.retry.backoff.ms";
    private static final long FETCH_OFFSET_RETRY_BACKOFF_MS_DEFAULT = 100L;
    private static final String FETCH_OFFSET_RETRY_BACKOFF_MS_CONFIG_DOC = "The amount of time in milliseconds to wait before attempting to retry a failed fetch offset request.";
    static final ConfigDef config = ConsumerOffsetsTranslatorConfig.baseConfigDef().define("fetch.offset.expiry.ms", ConfigDef.Type.LONG, (Object)600000L, ConfigDef.Importance.LOW, "The amount of time in milliseconds after which a fetch offset request expires and is then discarded.").define("fetch.offset.retry.backoff.ms", ConfigDef.Type.LONG, (Object)100L, ConfigDef.Importance.LOW, "The amount of time in milliseconds to wait before attempting to retry a failed fetch offset request.");

    public ConsumerOffsetsTranslatorConfig(Map<String, String> parsedConfig) {
        super(config, parsedConfig);
    }

    public long getFetchOffsetExpiryMs() {
        return this.getLong(FETCH_OFFSET_EXPIRY_MS_CONFIG);
    }

    public long getFetchOffsetRetryBackoffMs() {
        return this.getLong(FETCH_OFFSET_RETRY_BACKOFF_MS_CONFIG);
    }

    public Map<String, ?> getDestConsumerConfigs() {
        Map configs = this.originalsWithPrefix(KafkaConfigs.KafkaCluster.DESTINATION.prefix());
        configs.putAll(this.originalsWithPrefix("dest.consumer."));
        return configs;
    }
}

