/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.schemas;

import io.confluent.connect.replicator.ReplicatorSourceConnectorConfig;
import io.confluent.connect.replicator.Translator;
import io.confluent.connect.replicator.schemas.SubjectTranslator;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.storage.ConfigKey;
import io.confluent.kafka.schemaregistry.storage.ConfigValue;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectKey;
import io.confluent.kafka.schemaregistry.storage.DeleteSubjectValue;
import io.confluent.kafka.schemaregistry.storage.Mode;
import io.confluent.kafka.schemaregistry.storage.NoopKey;
import io.confluent.kafka.schemaregistry.storage.SchemaKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryKey;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistryValue;
import io.confluent.kafka.schemaregistry.storage.SchemaValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import io.confluent.kafka.schemaregistry.storage.serialization.SchemaRegistrySerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaTranslator
implements Translator {
    private static final Logger log = LoggerFactory.getLogger(SchemaTranslator.class);
    public static final String SCHEMA_REGISTRY_CLIENT_PREFIX = "schema.registry.client";
    private final ReplicatorSourceConnectorConfig config;
    private final SchemaRegistryClient schemaRegistry;
    private final SchemaRegistrySerializer serializer;
    private final SubjectTranslator subjectTranslator;
    private final NoopKey noopKey;
    private final Time time;
    private final List<ConsumerRecord<byte[], byte[]>> collectedRecords = new ArrayList<ConsumerRecord<byte[], byte[]>>();

    public SchemaTranslator(ReplicatorSourceConnectorConfig config, Time time) {
        this(config, (SchemaRegistryClient)new CachedSchemaRegistryClient(config.getSchemaRegistryUrls(), config.getMaxSchemasPerSubject(), Arrays.asList(new AvroSchemaProvider(), new JsonSchemaProvider(), new ProtobufSchemaProvider()), config.originalsWithPrefix("schema.registry.client.")), time);
    }

    public SchemaTranslator(Map<String, String> config, Time time) {
        this(config != null ? new ReplicatorSourceConnectorConfig(config) : null, time);
    }

    public SchemaTranslator(ReplicatorSourceConnectorConfig config, SchemaRegistryClient schemaRegistry, Time time) {
        this.config = config;
        this.schemaRegistry = schemaRegistry;
        this.serializer = new SchemaRegistrySerializer();
        this.subjectTranslator = config.getSubjectTranslator();
        this.noopKey = new NoopKey();
        this.time = time;
    }

    @Override
    public String topic() {
        return this.config.getSchemaRegistryTopic();
    }

    @Override
    public boolean canReadyStateChange() {
        return true;
    }

    @Override
    public boolean isDestinationReady() {
        try {
            String mode = this.schemaRegistry.getMode();
            boolean isReady = mode.equalsIgnoreCase(Mode.IMPORT.toString());
            if (!isReady) {
                this.schemaRegistry.reset();
            }
            return isReady;
        }
        catch (RestClientException | IOException e) {
            log.warn("Encountered exception when checking for destination schema registry readiness: ", e);
            return false;
        }
    }

    @Override
    public void collect(List<ConsumerRecord<byte[], byte[]>> record) {
        this.collectedRecords.addAll(record);
    }

    @Override
    public List<ConsumerRecord<byte[], byte[]>> translateCollectedRecords() {
        ArrayList<ConsumerRecord<byte[], byte[]>> translatedRecords = new ArrayList<ConsumerRecord<byte[], byte[]>>(this.collectedRecords);
        this.translateSchemas(translatedRecords);
        this.collectedRecords.clear();
        return translatedRecords;
    }

    private void translateSchemas(List<ConsumerRecord<byte[], byte[]>> records) {
        log.debug("Translating {} schema records", (Object)records.size());
        for (ConsumerRecord<byte[], byte[]> record : records) {
            SchemaRegistryValue message;
            SchemaRegistryKey messageKey;
            try {
                messageKey = this.serializer.deserializeKey((byte[])record.key());
            }
            catch (SerializationException e) {
                log.error("Failed to deserialize the schema or config key", (Throwable)e);
                continue;
            }
            if (messageKey.equals((Object)this.noopKey) || record.value() == null) continue;
            try {
                message = this.serializer.deserializeValue(messageKey, (byte[])record.value());
            }
            catch (SerializationException e) {
                log.error("Failed to deserialize a schema or config value", (Throwable)e);
                continue;
            }
            try {
                long now = this.time.milliseconds();
                log.debug("Translating schema registry record (" + String.valueOf(messageKey) + "," + String.valueOf(message) + ")");
                switch (messageKey.getKeyType()) {
                    case SCHEMA: {
                        this.translateSchema((SchemaKey)messageKey, (SchemaValue)message);
                        break;
                    }
                    case CONFIG: {
                        this.translateConfig((ConfigKey)messageKey, (ConfigValue)message);
                        break;
                    }
                    case DELETE_SUBJECT: {
                        this.translateDeleteSubject((DeleteSubjectKey)messageKey, (DeleteSubjectValue)message);
                        break;
                    }
                    case CLEAR_SUBJECT: {
                        break;
                    }
                    case MODE: {
                        break;
                    }
                    case NOOP: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported key type " + String.valueOf(messageKey.getKeyType()));
                    }
                }
                log.debug("Finished translating schema registry record (" + String.valueOf(messageKey) + "," + String.valueOf(message) + ") in {} ms", (Object)(this.time.milliseconds() - now));
            }
            catch (Exception se) {
                log.error("Failed to translate schema registry record", (Throwable)se);
            }
        }
    }

    private void translateSchema(SchemaKey key, SchemaValue value) throws IOException, RestClientException {
        String subject = this.subjectTranslator.translate(key.getSubject());
        if (value.isDeleted()) {
            this.schemaRegistry.deleteSchemaVersion(subject, String.valueOf(value.getVersion()));
        } else {
            Optional schema = this.schemaRegistry.parseSchema(value.toSchemaEntity());
            if (!schema.isPresent()) {
                throw new IOException("Could not parse schema " + value.getSchema() + " with type " + value.getSchemaType() + " with references " + String.valueOf(value.getReferences()));
            }
            this.schemaRegistry.register(subject, (ParsedSchema)schema.get(), value.getVersion().intValue(), value.getId().intValue());
        }
    }

    private void translateConfig(ConfigKey key, ConfigValue value) throws IOException, RestClientException {
        String subject = this.subjectTranslator.translate(key.getSubject());
        this.schemaRegistry.updateCompatibility(subject, value.getCompatibilityLevel().name);
    }

    private void translateDeleteSubject(DeleteSubjectKey key, DeleteSubjectValue value) throws IOException, RestClientException {
        String subject = this.subjectTranslator.translate(key.getSubject());
        this.schemaRegistry.deleteSubject(subject);
    }
}

