/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.replicator.util;

import io.confluent.connect.replicator.Translator;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranslatorMonitor
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(TranslatorMonitor.class);
    private final long maxAgeMs;
    private ScheduledExecutorService readyStateExecutor;
    private Collection<Translator> translators;
    private TranslatorListener listener;

    public TranslatorMonitor(long maxAgeMs) {
        this.maxAgeMs = maxAgeMs;
    }

    protected ScheduledExecutorService readyStateExecutor() {
        return this.readyStateExecutor;
    }

    public synchronized void setInterestedTranslators(Collection<Translator> translators, TranslatorListener listener) {
        this.translators = translators.stream().filter(Translator::canReadyStateChange).collect(Collectors.toList());
        this.listener = listener;
        if (this.maxAgeMs > 0L && translators.size() > 0) {
            this.readyStateExecutor = Executors.newSingleThreadScheduledExecutor();
            this.schedulePeriodicReadyStateCheck();
        }
    }

    private void schedulePeriodicReadyStateCheck() {
        this.readyStateExecutor.scheduleWithFixedDelay(new ReadyStateChecker(this.translators, this.listener), 0L, this.maxAgeMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        if (this.readyStateExecutor != null) {
            this.readyStateExecutor.shutdownNow();
        }
    }

    public static interface TranslatorListener {
        public void onNotReady();
    }

    protected class ReadyStateChecker
    implements Runnable {
        private final Collection<Translator> translators;
        private final TranslatorListener listener;

        public ReadyStateChecker(Collection<Translator> translators, TranslatorListener listener) {
            this.translators = translators;
            this.listener = listener;
        }

        @Override
        public void run() {
            try {
                this.checkReadyStates();
                log.trace("Checked ready state for interested translators");
            }
            catch (RuntimeException e) {
                log.warn("Failed to check ready state. Will try again in {}ms.", (Object)TranslatorMonitor.this.maxAgeMs, (Object)e);
            }
        }

        private void checkReadyStates() {
            if (this.listener != null && this.translators.stream().anyMatch(t -> !t.isDestinationReady())) {
                this.listener.onNotReady();
            }
        }
    }
}

