/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.auth;

public class PbkdfBase64 {
    private static final char[] BASE64_CODE = new char[]{'.', '/', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final byte[] INDEX_64 = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, -1, -1, -1, -1, -1, -1, -1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, -1, -1, -1, -1, -1, -1, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, -1, -1, -1, -1, -1};

    public static String encode(byte[] d, int len) throws IllegalArgumentException {
        int off = 0;
        StringBuffer rs = new StringBuffer();
        if (len <= 0 || len > d.length) {
            throw new IllegalArgumentException("Invalid len");
        }
        while (off < len) {
            int c1 = d[off++] & 0xFF;
            rs.append(BASE64_CODE[c1 >> 2 & 0x3F]);
            c1 = (c1 & 3) << 4;
            if (off >= len) {
                rs.append(BASE64_CODE[c1 & 0x3F]);
                break;
            }
            int c2 = d[off++] & 0xFF;
            rs.append(BASE64_CODE[(c1 |= c2 >> 4 & 0xF) & 0x3F]);
            c1 = (c2 & 0xF) << 2;
            if (off >= len) {
                rs.append(BASE64_CODE[c1 & 0x3F]);
                break;
            }
            c2 = d[off++] & 0xFF;
            rs.append(BASE64_CODE[(c1 |= c2 >> 6 & 3) & 0x3F]);
            rs.append(BASE64_CODE[c2 & 0x3F]);
        }
        return rs.toString();
    }

    private static byte char64(char x) {
        if (x < '\u0000' || x > INDEX_64.length) {
            return -1;
        }
        return INDEX_64[x];
    }

    public static byte[] decode(String s, int maxolen) throws IllegalArgumentException {
        int olen;
        StringBuffer rs = new StringBuffer();
        int off = 0;
        int slen = s.length();
        if (maxolen <= 0) {
            throw new IllegalArgumentException("Invalid maxolen");
        }
        for (olen = 0; off < slen - 1 && olen < maxolen; ++olen) {
            byte c3;
            byte c1 = PbkdfBase64.char64(s.charAt(off++));
            byte c2 = PbkdfBase64.char64(s.charAt(off++));
            if (c1 == -1 || c2 == -1) break;
            byte o = (byte)(c1 << 2);
            o = (byte)(o | (byte)((c2 & 0x30) >> 4));
            rs.append((char)o);
            if (++olen >= maxolen || off >= slen || (c3 = PbkdfBase64.char64(s.charAt(off++))) == -1) break;
            o = (byte)((c2 & 0xF) << 4);
            o = (byte)(o | (byte)((c3 & 0x3C) >> 2));
            rs.append((char)o);
            if (++olen >= maxolen || off >= slen) break;
            byte c4 = PbkdfBase64.char64(s.charAt(off++));
            o = (byte)((c3 & 3) << 6);
            o = (byte)(o | c4);
            rs.append((char)o);
        }
        byte[] ret = new byte[olen];
        for (off = 0; off < olen; ++off) {
            ret[off] = (byte)rs.charAt(off);
        }
        return ret;
    }
}

