/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.store.kafka.clients;

import io.confluent.security.authorizer.utils.JsonMapper;
import io.confluent.security.store.kafka.clients.JsonSerde;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.kafka.common.header.Headers;

public class DeserializationErrorHandlingJsonSerde<T>
extends JsonSerde<T> {
    private final Function<DeserializationError, T> handleDeserializationExceptionFunction;
    private boolean isKey;

    private DeserializationErrorHandlingJsonSerde(Class<T> clazz, Function<DeserializationError, T> handleDeserializationExceptionFunction) {
        super(clazz);
        this.handleDeserializationExceptionFunction = Objects.requireNonNull(handleDeserializationExceptionFunction);
    }

    @Override
    public void configure(Map<String, ?> configs, boolean isKey) {
        this.configure(configs);
        this.isKey = isKey;
    }

    public T deserialize(String topic, Headers headers, byte[] data) {
        if (data != null) {
            try {
                return (T)JsonMapper.objectMapper().readValue(data, this.clazz);
            }
            catch (IOException e) {
                return this.returnFromFunction(headers, data, e);
            }
        }
        return null;
    }

    @Override
    public T deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    private T returnFromFunction(Headers headers, byte[] data, Exception exception) {
        DeserializationError deserializationError = new DeserializationError(headers, data, this.isKey, exception);
        return this.handleDeserializationExceptionFunction.apply(deserializationError);
    }

    public static <T> DeserializationErrorHandlingJsonSerde<T> serde(Class<T> clazz, boolean isKey, Function<DeserializationError, T> handleDeserializationExceptionFunction) {
        DeserializationErrorHandlingJsonSerde<T> serde = new DeserializationErrorHandlingJsonSerde<T>(clazz, handleDeserializationExceptionFunction);
        serde.configure(Collections.emptyMap(), isKey);
        return serde;
    }

    public static class DeserializationError {
        private final Headers headers;
        private final byte[] data;
        private final boolean isForKey;
        private final Exception exception;

        public DeserializationError(Headers headers, byte[] data, boolean isForKey, Exception exception) {
            this.headers = headers;
            this.data = Arrays.copyOf(data, data.length);
            this.isForKey = isForKey;
            this.exception = exception;
        }

        public Headers getHeaders() {
            return this.headers;
        }

        public byte[] getData() {
            return Arrays.copyOf(this.data, this.data.length);
        }

        public boolean isForKey() {
            return this.isForKey;
        }

        public Exception getException() {
            return this.exception;
        }

        public String toString() {
            return "DeserializationError{, headers=" + String.valueOf(this.headers) + ", data=" + Arrays.toString(this.data) + ", isForKey=" + this.isForKey + ", exception=" + String.valueOf(this.exception) + "}";
        }
    }
}

