/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.metrics.reporter;

import io.confluent.metrics.record.ConfluentMetric;
import io.confluent.metrics.reporter.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMetricsHelper {
    private static final Logger log = LoggerFactory.getLogger(KafkaMetricsHelper.class);
    private static final ConfluentMetric.KafkaMetricName.Builder KAFKA_METRIC_NAME_BUILDER = ConfluentMetric.KafkaMetricName.newBuilder();
    private static final ConfluentMetric.KafkaMeasurable.Builder KAFKA_MEASURABLE_BUILDER = ConfluentMetric.KafkaMeasurable.newBuilder();

    private KafkaMetricsHelper() {
    }

    public static List<ConfluentMetric.KafkaMeasurable> collectKafkaMetrics(Map<MetricName, KafkaMetric> metricMap, Pattern pattern) {
        ArrayList<ConfluentMetric.KafkaMeasurable> kafkaMeasurables = new ArrayList<ConfluentMetric.KafkaMeasurable>();
        for (Map.Entry<MetricName, KafkaMetric> entry : metricMap.entrySet()) {
            MetricName metricName = entry.getKey();
            if (pattern != null && !pattern.matcher(metricName.name()).matches()) continue;
            Object metricValue = entry.getValue().metricValue();
            if (metricValue instanceof Double) {
                double value = (Double)metricValue;
                KAFKA_MEASURABLE_BUILDER.clear();
                KAFKA_MEASURABLE_BUILDER.setValue(value);
                KAFKA_METRIC_NAME_BUILDER.clear();
                KAFKA_METRIC_NAME_BUILDER.setGroup(Utils.notNullOrEmpty(metricName.group()));
                KAFKA_METRIC_NAME_BUILDER.setName(Utils.notNullOrEmpty(metricName.name()));
                KAFKA_METRIC_NAME_BUILDER.putAllTags(metricName.tags());
                KAFKA_MEASURABLE_BUILDER.setMetricName(KAFKA_METRIC_NAME_BUILDER.build());
                kafkaMeasurables.add(KAFKA_MEASURABLE_BUILDER.build());
                continue;
            }
            log.debug("Skipping non-measurable metric {}", (Object)metricName.name());
        }
        return kafkaMeasurables;
    }
}

