/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.config.ServerConfigs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(BrokerConfigUtils.class);
    protected static final String RACK_PROP = "broker.rack";
    protected static final String ADVERTISED_LISTENERS_PROP = "advertised.listeners";
    protected static final String LISTENERS_PROP = "listeners";
    protected static final String LISTENER_DEFAULT = "PLAINTEXT://:9092";
    protected static final String LISTENER_SECURITY_PROTOCOL_MAP_PROP = "listener.security.protocol.map";
    protected static final String LISTENER_SECURITY_PROTOCOL_MAP_DEFAULT = Joiner.on((String)",").withKeyValueSeparator(":").join(Arrays.stream(SecurityProtocol.values()).collect(Collectors.toMap(sp -> ListenerName.forSecurityProtocol((SecurityProtocol)sp).value(), sp -> sp)));
    protected static final String INTER_BROKER_SECURITY_PROTOCOL_PROP = "security.inter.broker.protocol";
    protected static final String INTER_BROKER_SECURITY_PROTOCOL_DEFAULT = SecurityProtocol.PLAINTEXT.toString();
    protected static final String INTER_BROKER_LISTENER_NAME_PROP = "inter.broker.listener.name";
    protected static final String INTER_BROKER_LISTENER_NAME_DEFAULT = null;
    protected static final String URI_PARSE_REGEX_STRING = "^(.*)://\\[?([0-9a-zA-Z\\-%._:]*)\\]?:(-?[0-9]+)";
    private static final Class<?> CONFLUENT_CONFIGS_CLASS;
    private static final MethodHandle INTER_BROKER_CLIENT_CONFIGS_METHOD;
    private static final Exception INTER_BROKER_CLIENT_CONFIGS_EXCEPTION;

    public static String getBalanceReplicationFactor(Map<String, Object> config) {
        if (CONFLUENT_CONFIGS_CLASS == null) {
            throw new RuntimeException("unable to locate ConfluentConfigs class", INTER_BROKER_CLIENT_CONFIGS_EXCEPTION);
        }
        try {
            String configName = (String)CONFLUENT_CONFIGS_CLASS.getDeclaredField("BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG").get(null);
            return BrokerConfigUtils.getStringOrDefault(config, configName, null);
        }
        catch (Exception e) {
            throw new RuntimeException("unable look up balancer replication factor config name", e);
        }
    }

    private static String getAdvertisedListeners(Map<String, Object> config) {
        String advertisedListeners = BrokerConfigUtils.getStringOrDefault(config, ADVERTISED_LISTENERS_PROP, null);
        if (advertisedListeners != null) {
            return advertisedListeners;
        }
        String listeners = BrokerConfigUtils.getStringOrDefault(config, LISTENERS_PROP, LISTENER_DEFAULT);
        return listeners;
    }

    private static String getInterBrokerSecurityProtocol(Map<String, Object> config) {
        return BrokerConfigUtils.getStringOrDefault(config, INTER_BROKER_SECURITY_PROTOCOL_PROP, INTER_BROKER_SECURITY_PROTOCOL_DEFAULT);
    }

    private static String getListenerSecurityProtocolMap(Map<String, Object> config) {
        return BrokerConfigUtils.getStringOrDefault(config, LISTENER_SECURITY_PROTOCOL_MAP_PROP, LISTENER_SECURITY_PROTOCOL_MAP_DEFAULT);
    }

    private static String getInterBrokerListenerName(Map<String, Object> config) {
        return BrokerConfigUtils.getStringOrDefault(config, INTER_BROKER_LISTENER_NAME_PROP, INTER_BROKER_LISTENER_NAME_DEFAULT);
    }

    private static String getStringOrDefault(Map<String, Object> config, String prop, String defaultValue) {
        Object val = config.get(prop);
        if (val == null) {
            return defaultValue;
        }
        return val.toString();
    }

    private static Map<ListenerName, SecurityProtocol> listenerSecurityProtocolMap(Map<String, Object> config) {
        String value = BrokerConfigUtils.getListenerSecurityProtocolMap(config);
        HashMap map = Maps.newHashMap();
        if (Strings.isNullOrEmpty((String)value)) {
            return map;
        }
        return Arrays.stream(value.split("\\s*,\\s*")).collect(Collectors.toMap(s -> ListenerName.normalised((String)s.substring(0, s.lastIndexOf(":")).trim()), s -> SecurityProtocol.forName((String)s.substring(s.lastIndexOf(":") + 1).trim())));
    }

    private static Map.Entry<ListenerName, SecurityProtocol> deriveInterBrokerListener(Map<String, Object> config, Map<ListenerName, SecurityProtocol> listenerSecurityProtocolMap) {
        String listenerNameStr = BrokerConfigUtils.getInterBrokerListenerName(config);
        if (!Strings.isNullOrEmpty((String)listenerNameStr)) {
            ListenerName listenerName = ListenerName.normalised((String)listenerNameStr);
            SecurityProtocol securityProtocol = listenerSecurityProtocolMap.get(listenerName);
            if (securityProtocol == null) {
                throw new ConfigException("no security protocol for the provided listener name");
            }
            return new AbstractMap.SimpleEntry<ListenerName, SecurityProtocol>(listenerName, securityProtocol);
        }
        SecurityProtocol securityProtocol = SecurityProtocol.forName((String)BrokerConfigUtils.getInterBrokerSecurityProtocol(config));
        return new AbstractMap.SimpleEntry<ListenerName, SecurityProtocol>(ListenerName.forSecurityProtocol((SecurityProtocol)securityProtocol), securityProtocol);
    }

    private static Endpoint createEndPoint(String connectionString, Map<ListenerName, SecurityProtocol> listenerSecurityProtocolMap) {
        Pattern uriParseRegex = Pattern.compile(URI_PARSE_REGEX_STRING);
        Matcher matcher = uriParseRegex.matcher(connectionString);
        if (!matcher.find()) {
            throw new ConfigException(connectionString + " is not a valid listener");
        }
        String listenerNameStr = matcher.group(1);
        String host = matcher.group(2);
        String port = matcher.group(3);
        ListenerName listenerName = ListenerName.normalised((String)listenerNameStr);
        return new Endpoint(listenerName.value(), listenerSecurityProtocolMap.get(listenerName), host.isEmpty() ? null : host, Integer.parseInt(port));
    }

    private static List<Endpoint> getEndpoints(Map<String, Object> config, Map<ListenerName, SecurityProtocol> listenerSecurityProtocolMap) {
        String listeners = BrokerConfigUtils.getAdvertisedListeners(config);
        List listenersList = Arrays.stream(listeners.split("\\s*,\\s*")).filter(v -> !v.equals("")).collect(Collectors.toList());
        return listenersList.stream().map(l -> BrokerConfigUtils.createEndPoint(l, listenerSecurityProtocolMap)).collect(Collectors.toList());
    }

    public static Endpoint getInterBrokerEndpoint(Map<String, Object> config) {
        Map<ListenerName, SecurityProtocol> listenerSecurityProtocolMap = BrokerConfigUtils.listenerSecurityProtocolMap(config);
        ListenerName listenerName = BrokerConfigUtils.deriveInterBrokerListener(config, listenerSecurityProtocolMap).getKey();
        List endpoints = BrokerConfigUtils.getEndpoints(config, listenerSecurityProtocolMap).stream().filter(e -> {
            if (e.listenerName().isPresent()) {
                return ((String)e.listenerName().get()).equals(listenerName.value());
            }
            return true;
        }).collect(Collectors.toList());
        if (endpoints.size() != 1) {
            throw new ConfigException("expecting a single interbroker endpoint");
        }
        Endpoint endpoint = (Endpoint)endpoints.get(0);
        if (endpoint.port() == 0) {
            log.warn("Interbroker listener port is 0. Local exporter configuration may be invalid.");
        }
        return endpoint;
    }

    private static Map<String, Object> interBrokerClientConfigs(Map<String, Object> config) {
        try {
            if (INTER_BROKER_CLIENT_CONFIGS_METHOD == null) {
                throw INTER_BROKER_CLIENT_CONFIGS_EXCEPTION;
            }
            return INTER_BROKER_CLIENT_CONFIGS_METHOD.invokeExact(config, BrokerConfigUtils.getInterBrokerEndpoint(config));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> deriveLocalProducerConfigs(Map<String, Object> originals) {
        try {
            Map<String, Object> clientConfigs = BrokerConfigUtils.interBrokerClientConfigs(originals);
            Set producerConfigs = ProducerConfig.configNames();
            Set adminConfigs = AdminClientConfig.configNames();
            return clientConfigs.entrySet().stream().filter(e -> producerConfigs.contains(e.getKey()) || adminConfigs.contains(e.getKey())).filter(e -> !((String)e.getKey()).equals("metric.reporters")).filter(e -> !((String)e.getKey()).equals("client.id")).filter(e -> !((String)e.getKey()).equals(ServerConfigs.COMPRESSION_TYPE_CONFIG)).filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> "producer." + (String)e.getKey(), Map.Entry::getValue));
        }
        catch (Exception e2) {
            log.error("Exception invoking ConfluentConfigs.interBrokerClientConfigs", (Throwable)e2);
            return ImmutableMap.of();
        }
    }

    public static Optional<String> getBrokerRack(Map<String, Object> configs) {
        return Optional.ofNullable((String)configs.get(RACK_PROP));
    }

    static {
        Class<?> confluentConfigsClass = null;
        MethodHandle method = null;
        Exception exception = null;
        try {
            confluentConfigsClass = Class.forName("org.apache.kafka.common.config.internals.ConfluentConfigs");
            method = MethodHandles.publicLookup().findStatic(confluentConfigsClass, "clientConfigsForEndpoint", MethodType.methodType(Map.class, Map.class, Endpoint.class));
        }
        catch (Exception e) {
            exception = e;
        }
        if (method != null) {
            CONFLUENT_CONFIGS_CLASS = confluentConfigsClass;
            INTER_BROKER_CLIENT_CONFIGS_METHOD = method;
            INTER_BROKER_CLIENT_CONFIGS_EXCEPTION = null;
        } else {
            CONFLUENT_CONFIGS_CLASS = null;
            INTER_BROKER_CLIENT_CONFIGS_METHOD = null;
            INTER_BROKER_CLIENT_CONFIGS_EXCEPTION = exception;
        }
    }
}

