/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.confluent.telemetry.NamedConfigUtils;
import io.confluent.telemetry.RegexConfigDefValidator;
import io.confluent.telemetry.collector.VolumeMetricsCollector;
import io.confluent.telemetry.config.FilterSetPredicate;
import io.confluent.telemetry.config.remote.RemoteConfigConfiguration;
import io.confluent.telemetry.config.remote.file.FileRemoteConfigConfiguration;
import io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationConfig;
import io.confluent.telemetry.config.remote.polling.kubernetes.KubernetesRemoteConfigurationConfig;
import io.confluent.telemetry.config.v2.NamedFilter;
import io.confluent.telemetry.config.v2.SimpleNamedFilter;
import io.confluent.telemetry.exporter.ClientConfig;
import io.confluent.telemetry.exporter.ExporterConfig;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.http.HttpConfigUtils;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import io.confluent.telemetry.exporter.kafka.ProducerClientConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentTelemetryConfig
extends AbstractConfig {
    private static final Logger log = LoggerFactory.getLogger(ConfluentTelemetryConfig.class);
    private final boolean doLog;
    public static final String PREFIX = "confluent.telemetry.";
    public static final String PREFIX_LABELS = "confluent.telemetry.labels.";
    public static final String PREFIX_EXPORTER = "confluent.telemetry.exporter.";
    public static final String PREFIX_EXPORTER_CLIENT = "confluent.telemetry.client.";
    public static final String PREFIX_METRICS_COLLECTOR = "confluent.telemetry.metrics.collector.";
    public static final String CLUSTER_ID_CONFIG = "confluent.telemetry.cluster.id";
    public static final String CLUSTER_ID_DOC = "The ID of the physical cluster the Telemetry Reporter is configured for";
    public static final String COLLECT_INTERVAL_CONFIG = "confluent.telemetry.metrics.collector.interval.ms";
    public static final Long DEFAULT_COLLECT_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    public static final String COLLECT_INTERVAL_DOC = "The metrics reporter will collect new metrics from the system in intervals defined by this setting. This means that control center system health data lags by this duration, or that rebalancer may compute a plan based on broker data that is stale by this duration. The default is a reasonable value for production environments and it typically does not need to be changed.";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS = "confluent.telemetry.external.client.metrics.exclude.labels";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS_DOC = "Comma-separated list of labels/attributes to exclude from client metrics.";
    public static final String TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS_DEFAULT = "";
    public static final String METRICS_INCLUDE_CONFIG = "confluent.telemetry.metrics.collector.include";
    public static final String SLO_COLLECTOR_ENABLED = "confluent.telemetry.metrics.collector.slo.enabled";
    public static final Boolean DEFAULT_SLO_COLLECTOR_ENABLED = false;
    public static final String SLO_COLLECTOR_DOC = "Enable SLO metric collector";
    public static final String DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX = "io\\.confluent\\.system/(?:.*/)?(" + String.join((CharSequence)"|", "process_cpu_load", "max_file_descriptor_count", "open_file_descriptor_count", "system_cpu_load", "system_load_average", "free_physical_memory_size", "total_physical_memory_size", "disk_total_bytes", "disk_usable_bytes", "jvm/mem", "jvm/gc") + ")";
    public static final String METRICS_INCLUDE_DOC = "Regex matching the converted (snake_case) metric name to be published to the metrics topic.\n\nBy default this includes all the metrics required by Proactive Support and Self-balancing Clusters. This should typically never be modified unless requested by Confluent.";
    public static final String DEFAULT_METRICS_INCLUDE;
    public static final String CONFIG_EVENTS_ENABLE_CONFIG = "confluent.telemetry.events.enable";
    public static final String CONFIG_EVENTS_ENABLE_DOC = "Enable config events collection.Enabled by default for v7.0.";
    public static final Boolean CONFIG_EVENTS_ENABLE_DEFAULT;
    public static final String CONFIG_EVENTS_INCLUDE_CONFIG = "confluent.telemetry.events.collector.include";
    public static final String CONFIG_EVENTS_INCLUDE_DOC = "Regex matching the config names to be published to telemetry collector.This should typically never be modified unless requested by Confluent.";
    public static final String CONFIG_EVENTS_INCLUDE_DEFAULT;
    public static final List<String> CONFIG_EVENTS_INCLUDE;
    public static final String DEBUG_ENABLED = "confluent.telemetry.debug.enabled";
    public static final String DEBUG_ENABLED_DOC = "Enable debug metadata for metrics collection";
    public static final boolean DEFAULT_DEBUG_ENABLED = false;
    public static final String DEFAULT_NAMED_FILTER_NAME = "_default";
    public static final Set<String> DEFAULT_ACTIVE_FILTER_SET;
    public static final String CPU_METRIC;
    public static final String EXPORTER_LOCAL_NAME = "_local";
    public static final String EXPORTER_LOCAL_METRICS_INCLUDE;
    public static final Map<String, Object> EXPORTER_LOCAL_DEFAULTS;
    public static final String EXPORTER_C3PLUSPLUS_NAME = "_c3";
    public static final String EXPORTER_C3PLUSPLUS_METRICS_INCLUDE = "(io.confluent.kafka.server.request.(?!.*delta).*|io.confluent.kafka.server.server.broker.state|io.confluent.kafka.server.replica.manager.leader.count|io.confluent.kafka.server.request.queue.size|io.confluent.kafka.server.broker.topic.failed.produce.requests.rate.1_min|io.confluent.kafka.server.tier.archiver.total.lag|io.confluent.kafka.server.request.total.time.ms.p99|io.confluent.kafka.server.broker.topic.failed.fetch.requests.rate.1_min|io.confluent.kafka.server.log.total.size|io.confluent.kafka.server.broker.topic.total.fetch.requests.rate.1_min|io.confluent.kafka.server.partition.caught.up.replicas.count|io.confluent.kafka.server.partition.observer.replicas.count|io.confluent.kafka.server.tier.tasks.num.partitions.in.error|io.confluent.kafka.server.broker.topic.bytes.out.rate.1_min|io.confluent.kafka.server.request.total.time.ms.p95|io.confluent.kafka.server.controller.active.controller.count|io.confluent.kafka.server.session.expire.listener.zookeeper.disconnects.total|io.confluent.kafka.server.request.total.time.ms.p999|io.confluent.kafka.server.controller.active.broker.count|io.confluent.kafka.server.request.handler.pool.request.handler.avg.idle.percent.rate.1_min|io.confluent.kafka.server.session.expire.listener.zookeeper.disconnects.rate.1_min|io.confluent.kafka.server.controller.unclean.leader.elections.rate.1_min|io.confluent.kafka.server.replica.manager.partition.count|io.confluent.kafka.server.controller.unclean.leader.elections.total|io.confluent.kafka.server.partition.replicas.count|io.confluent.kafka.server.broker.topic.total.produce.requests.rate.1_min|io.confluent.kafka.server.controller.offline.partitions.count|io.confluent.kafka.server.socket.server.network.processor.avg.idle.percent|io.confluent.kafka.server.partition.under.replicated|io.confluent.kafka.server.log.log.start.offset|io.confluent.kafka.server.log.tier.size|io.confluent.kafka.server.log.size|io.confluent.kafka.server.tier.fetcher.bytes.fetched.total|io.confluent.kafka.server.request.total.time.ms.p50|io.confluent.kafka.server.tenant.consumer.lag.offsets|io.confluent.kafka.server.session.expire.listener.zookeeper.expires.rate.1_min|io.confluent.kafka.server.log.log.end.offset|io.confluent.kafka.server.log.num.log.segments|io.confluent.kafka.server.broker.topic.bytes.in.rate.1_min|io.confluent.kafka.server.partition.under.min.isr|io.confluent.kafka.server.partition.in.sync.replicas.count|io.confluent.telemetry.http.exporter.batches.dropped|io.confluent.telemetry.http.exporter.items.total|io.confluent.telemetry.http.exporter.items.succeeded|io.confluent.telemetry.http.exporter.send.time.total.millis|io.confluent.kafka.server.controller.leader.election.rate.(?!.*delta).*|io.confluent.telemetry.http.exporter.batches.failed)";
    public static final Map<String, Object> EXPORTER_C3PLUSPLUS_DEFAULTS;
    public static final String TELEMETRY_CONFLUENT_CLOUD_URL = "https://collector.telemetry.confluent.cloud";
    public static final String EXPORTER_CONFLUENT_NAME = "_confluent";
    public static final String CLIENT_CONFLUENT_NAME = "_confluentClient";
    public static final Map<String, Object> EXPORTER_CONFLUENT_DEFAULTS;
    public static final Map<String, Object> CLIENT_CONFLUENT_DEFAULTS;
    public static final Map<String, Map<String, Object>> EXPORTER_DEFAULT_CONFIGS;
    public static final Map<String, Map<String, Object>> CLIENT_DEFAULT_CONFIGS;
    public static final String PREFIX_REMOTE_CONFIG = "confluent.telemetry.remoteconfig.";
    private static final String REMOTE_CONFIG_CLOUD = "_cloud.";
    private static final String REMOTE_CONFIG_FILE = "file.";
    @VisibleForTesting
    public static final String REMOTE_CONFIG_CONFLUENT = "_confluent.";
    public static final String TELEMETRY_API_KEY = "confluent.telemetry.api.key";
    public static final String TELEMETRY_API_KEY_DOC = "The API key used to authenticate HTTP requests with the Confluent telemetry server";
    public static final String TELEMETRY_API_SECRET = "confluent.telemetry.api.secret";
    public static final String TELEMETRY_API_SECRET_DOC = "The API secret used to authenticate HTTP requests with the Confluent Telemetry server";
    public static final String TELEMETRY_ENABLED_CONFIG = "confluent.telemetry.enabled";
    public static final String TELEMETRY_ENABLED_DOC = "True if telemetry data can to be reported to Confluent Cloud";
    public static final boolean TELEMETRY_ENABLED_DEFAULT = false;
    public static final String TELEMETRY_PROXY_URL = "confluent.telemetry.proxy.url";
    public static final String TELEMETRY_PROXY_URL_DOC = "The URL for an explicit (i.e. not transparent) forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final String TELEMETRY_PROXY_USERNAME = "confluent.telemetry.proxy.username";
    public static final String TELEMETRY_PROXY_USERNAME_DOC = "The username credential for the forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final String TELEMETRY_PROXY_PASSWORD = "confluent.telemetry.proxy.password";
    public static final String TELEMETRY_PROXY_PASSWORD_DOC = "The password credential for the forward HTTP proxy to send Telemetry data to Confluent Cloud";
    public static final Set<String> RECONFIGURABLES;
    private static final ImmutableMap<String, String> TRANSLATED_CONFIG_MAP;
    private static final ImmutableMap<String, String> RECONCILABLE_CONFIG_MAP;
    public static final int DEFAULT_MIN_ISR = 1;
    private static final ConfigDef CONFIG;
    private final VolumeMetricsCollector.VolumeMetricsCollectorConfig volumeMetricsCollectorConfig;
    private final Map<String, ExporterConfig> exporterConfigMap;
    private final Map<String, ClientConfig> clientConfigMap;
    private final Optional<RemoteConfigConfiguration> remoteConfigConfiguration;
    private final Set<String> clientMetricsExcludeLabels;

    public static String joinIncludeRegexList(List<String> includeRegexList) {
        StringBuilder eventBuilder = new StringBuilder(".*");
        Joiner.on((String)".*|.*").appendTo(eventBuilder, includeRegexList);
        eventBuilder.append(".*");
        return eventBuilder.toString();
    }

    public static String exporterPrefixForName(String name) {
        return ConfluentTelemetryConfig.prefixForName(PREFIX_EXPORTER, name);
    }

    public static String clientPrefixForName(String name) {
        return ConfluentTelemetryConfig.prefixForName(PREFIX_EXPORTER_CLIENT, name);
    }

    private static String prefixForName(String prefix, String name) {
        return prefix + name + ".";
    }

    public ConfluentTelemetryConfig(Map<String, ?> originals) {
        this(originals, true);
    }

    public ConfluentTelemetryConfig(Map<String, ?> originals, boolean doLog) {
        super(CONFIG, ConfluentTelemetryConfig.reconcileConfigs(new HashMap(originals)), doLog);
        this.doLog = doLog;
        this.volumeMetricsCollectorConfig = new VolumeMetricsCollector.VolumeMetricsCollectorConfig(originals, doLog);
        this.clientConfigMap = this.createClientMap();
        this.exporterConfigMap = this.createExporterMap();
        if (this.enabledExporters().isEmpty()) {
            log.warn("no telemetry exporters are enabled");
        }
        this.remoteConfigConfiguration = this.parseRemoteConfigSourceConfiguration();
        this.clientMetricsExcludeLabels = this.parseClientMetricsExcludeLabels();
    }

    private Set<String> parseClientMetricsExcludeLabels() {
        String labels = this.getString(TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS);
        if (labels == null || labels.isEmpty()) {
            return ImmutableSet.of();
        }
        return Arrays.stream(labels.split(",")).map(String::trim).collect(Collectors.toUnmodifiableSet());
    }

    public Set<String> getClientMetricsExcludeLabels() {
        return this.clientMetricsExcludeLabels;
    }

    public static void main(String[] args) {
        System.out.println(CONFIG.toRst());
    }

    public Map<String, String> getLabels() {
        HashMap<String, String> labels = new HashMap<String, String>();
        for (Map.Entry entry : super.originals().entrySet()) {
            if (!((String)entry.getKey()).startsWith(PREFIX_LABELS)) continue;
            labels.put(((String)entry.getKey()).substring(PREFIX_LABELS.length()), (String)entry.getValue());
        }
        return labels;
    }

    public Boolean isDebugEnabled() {
        return this.getBoolean(DEBUG_ENABLED);
    }

    public FilterSetPredicate getDefaultFilterSet() {
        return FilterSetPredicate.fromNamedFilter((NamedFilter)new SimpleNamedFilter(DEFAULT_NAMED_FILTER_NAME, this.getString(METRICS_INCLUDE_CONFIG)));
    }

    public VolumeMetricsCollector.VolumeMetricsCollectorConfig getVolumeMetricsCollectorConfig() {
        return this.volumeMetricsCollectorConfig;
    }

    public Optional<RemoteConfigConfiguration> getRemoteConfigConfiguration() {
        return this.remoteConfigConfiguration;
    }

    public static Map<String, ?> reconcileConfigs(Map<String, ?> config) {
        Map<String, ?> tempConfig = config;
        for (Map.Entry entry : TRANSLATED_CONFIG_MAP.entrySet()) {
            if (!tempConfig.containsKey(entry.getKey())) continue;
            Object value = tempConfig.get(entry.getKey());
            tempConfig.put((String)entry.getValue(), value);
            tempConfig.remove(entry.getKey());
        }
        for (String reconcilableHighLevelKey : RECONCILABLE_CONFIG_MAP.keySet()) {
            String lowLevelKey = (String)RECONCILABLE_CONFIG_MAP.get((Object)reconcilableHighLevelKey);
            if (!tempConfig.containsKey(reconcilableHighLevelKey) || tempConfig.containsKey(lowLevelKey)) continue;
            log.info("Applying value of {} flag for default '{}' http exporter as {} isn't passed", new Object[]{reconcilableHighLevelKey, EXPORTER_CONFLUENT_NAME, lowLevelKey});
            tempConfig.put(lowLevelKey, tempConfig.get(reconcilableHighLevelKey));
        }
        return tempConfig;
    }

    private Map<String, ClientConfig> createClientMap() {
        HashMap<String, HashMap> clients = new HashMap<String, HashMap>();
        for (Map.Entry<String, Map<String, Object>> entry : CLIENT_DEFAULT_CONFIGS.entrySet()) {
            HashMap defaults = Maps.newHashMap(entry.getValue());
            clients.put(entry.getKey(), defaults);
        }
        NamedConfigUtils.parseNamedConfigs(clients, (Map)this.originalsWithPrefix(PREFIX_EXPORTER_CLIENT));
        HashMap<String, ClientConfig> clientConfigMap = new HashMap<String, ClientConfig>();
        for (Map.Entry entry : clients.entrySet()) {
            String clientName = (String)entry.getKey();
            clientConfigMap.put(clientName, this.createClientConfig(clientName, (Map)entry.getValue()));
        }
        return clientConfigMap;
    }

    private ClientConfig createClientConfig(String clientName, Map<String, Object> rawClientConfigs) {
        ClientConfig clientConfig;
        ClientConfig.ClientConfigType type;
        try {
            type = ClientConfig.parseType(rawClientConfigs.get("type"));
        }
        catch (ConfigException e) {
            throw new ConfigException(e.getMessage() + " for client " + clientName);
        }
        if (ClientConfig.ClientConfigType.kafkaProducer.equals((Object)type)) {
            clientConfig = new ProducerClientConfig(clientName, rawClientConfigs, this.doLog);
        } else if (ClientConfig.ClientConfigType.httpTelemetryClient.equals((Object)type)) {
            clientConfig = new HttpClientConfig(clientName, rawClientConfigs, this.doLog);
        } else {
            throw new RuntimeException("unexpected Client Config Type");
        }
        return clientConfig;
    }

    private Map<String, ExporterConfig> createExporterMap() {
        HashMap exporters = Maps.newHashMap();
        for (Map.Entry<String, Map<String, Object>> entry : EXPORTER_DEFAULT_CONFIGS.entrySet()) {
            HashMap defaults = Maps.newHashMap(entry.getValue());
            exporters.put(entry.getKey(), defaults);
        }
        HashMap exporterConfigs = Maps.newHashMap();
        exporterConfigs.putAll(this.originalsWithPrefix(PREFIX_EXPORTER));
        NamedConfigUtils.parseNamedConfigs((Map)exporters, (Map)exporterConfigs);
        HashMap exporterConfigMap = Maps.newHashMap();
        for (Map.Entry entry : exporters.entrySet()) {
            String exporterName = (String)entry.getKey();
            this.maybeCreateExporterConfig(exporterName, (Map)entry.getValue()).ifPresent(config -> exporterConfigMap.put(exporterName, config));
        }
        return exporterConfigMap;
    }

    private Optional<ExporterConfig> maybeCreateExporterConfig(String exporterName, Map<String, Object> rawConfig) {
        ExporterConfig config;
        block8: {
            ExporterConfig.ExporterType exporterType;
            Boolean isEnabled = (Boolean)ConfigDef.parseType((String)"enabled", (Object)rawConfig.get("enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
            Object exporterTypeConfig = rawConfig.get("type");
            if (isEnabled == null) {
                log.warn("Skipping exporter config of '{}' exporter as '{}' config is not defined.", (Object)exporterName, (Object)"enabled");
                return Optional.empty();
            }
            if (exporterTypeConfig == null && !isEnabled.booleanValue()) {
                log.warn("Skipping exporter config of '{}' exporter as it is disabled and its type is not defined.", (Object)exporterName);
                return Optional.empty();
            }
            try {
                exporterType = ExporterConfig.parseType(exporterTypeConfig);
            }
            catch (ConfigException e) {
                throw new ConfigException(e.getMessage() + " for exporter " + exporterName);
            }
            try {
                if (exporterType.equals((Object)ExporterConfig.ExporterType.kafka)) {
                    config = new KafkaExporterConfig(exporterName, rawConfig, (ProducerClientConfig)this.clientConfigMap.get((String)rawConfig.get("client")), this.doLog);
                    break block8;
                }
                if (exporterType.equals((Object)ExporterConfig.ExporterType.http)) {
                    config = new HttpExporterConfig(exporterName, rawConfig, (HttpClientConfig)this.clientConfigMap.get((String)rawConfig.get("client")), this.doLog);
                    break block8;
                }
                throw new RuntimeException("unexpected ExporterType value");
            }
            catch (Exception e) {
                throw new ConfigException(String.format("Failed to create exporter config for exporter '%s'. Reason: %s", exporterName, e.getMessage()));
            }
        }
        return Optional.of(config);
    }

    private Optional<RemoteConfigConfiguration> parseRemoteConfigSourceConfiguration() {
        boolean fileEnabled;
        boolean cloudEnabled;
        Map remoteConfigSourceConfigs = this.originalsWithPrefix(PREFIX_REMOTE_CONFIG);
        Boolean confluentEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("_confluent.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        Boolean cloudEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("_cloud.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        Boolean fileEnabledConfig = (Boolean)ConfigDef.parseType((String)"enabled", remoteConfigSourceConfigs.get("file.enabled"), (ConfigDef.Type)ConfigDef.Type.BOOLEAN);
        boolean confluentEnabled = Optional.ofNullable(confluentEnabledConfig).orElse(true);
        if ((confluentEnabled ? 1 : 0) + ((cloudEnabled = Optional.ofNullable(cloudEnabledConfig).orElse(false).booleanValue()) ? 1 : 0) + ((fileEnabled = Optional.ofNullable(fileEnabledConfig).orElse(false).booleanValue()) ? 1 : 0) > 1) {
            throw new ConfigException("Multiple RemoteConfigSources are enabled. Please disable one");
        }
        if (confluentEnabled) {
            Map pollingRemoteConfigs = this.originalsWithPrefix("confluent.telemetry.remoteconfig._confluent.");
            pollingRemoteConfigs.put("enabled", true);
            return Optional.of(new PollingRemoteConfigurationConfig(pollingRemoteConfigs, this.doLog));
        }
        if (cloudEnabled) {
            return Optional.of(new KubernetesRemoteConfigurationConfig(this.originalsWithPrefix("confluent.telemetry.remoteconfig._cloud."), this.doLog));
        }
        if (fileEnabled) {
            return Optional.of(new FileRemoteConfigConfiguration(this.originalsWithPrefix("confluent.telemetry.remoteconfig.file."), this.doLog));
        }
        return Optional.empty();
    }

    public void updateClientConfigs(String clientName, Map<String, ?> configOverrides) {
        ClientConfig oldConfig = this.clientConfigMap.get(clientName);
        if (oldConfig == null) {
            throw new NoSuchElementException("Client was not found: " + clientName);
        }
        this.clientConfigMap.put(clientName, oldConfig.reconfigure(configOverrides));
    }

    public void updateExporterConfigs(String exporterName, Map<String, ?> configOverrides) {
        ExporterConfig oldConfig = this.exporterConfigMap.get(exporterName);
        if (oldConfig == null) {
            throw new NoSuchElementException("Exporter was not found: " + exporterName);
        }
        this.exporterConfigMap.put(exporterName, oldConfig.reconfigure(configOverrides, this.clientConfigMap));
    }

    public void addClientConfig(String clientName, Map<String, Object> rawConfig) {
        ClientConfig clientConfig = this.createClientConfig(clientName, rawConfig);
        log.info("New client config created for '{}'", (Object)clientName);
        this.clientConfigMap.put(clientName, clientConfig);
    }

    public void addExporterConfig(String exporterName, Map<String, Object> rawConfig) {
        this.maybeCreateExporterConfig(exporterName, rawConfig).ifPresent(exporterConfig -> {
            log.info("New exporter config created for '{}'", (Object)exporterName);
            this.exporterConfigMap.put(exporterName, (ExporterConfig)((Object)exporterConfig));
        });
    }

    public Map<String, ExporterConfig> allExporters() {
        return ConfluentTelemetryConfig.filterExporterConfigMap(this.exporterConfigMap, null, null, null, ExporterConfig.class);
    }

    public Map<String, ExporterConfig> enabledExporters() {
        return ConfluentTelemetryConfig.filterExporterConfigMap(this.exporterConfigMap, null, true, null, ExporterConfig.class);
    }

    public Map<String, ExporterConfig> allExportersWithNames(Set<String> names) {
        return ConfluentTelemetryConfig.filterExporterConfigMap(this.exporterConfigMap, null, null, names, ExporterConfig.class);
    }

    public Map<String, HttpExporterConfig> allHttpExporters() {
        return ConfluentTelemetryConfig.filterExporterConfigMap(this.exporterConfigMap, ExporterConfig.ExporterType.http, null, null, HttpExporterConfig.class);
    }

    public Map<String, HttpClientConfig> allHttpClients() {
        return ConfluentTelemetryConfig.filterClientConfigMap(this.clientConfigMap, ClientConfig.ClientConfigType.httpTelemetryClient, null, null, HttpClientConfig.class);
    }

    public boolean hasExporterWithName(String exporterName) {
        return this.allExporters().containsKey(exporterName);
    }

    public boolean hasClientWithName(String clientName) {
        return this.clientConfigMap.containsKey(clientName);
    }

    private static <T> Map<String, T> filterExporterConfigMap(Map<String, ExporterConfig> configNameMap, ExporterConfig.ExporterType type, Boolean isEnabled, Set<String> names, Class<T> castTo) {
        return configNameMap.entrySet().stream().filter(e -> type == null || ((ExporterConfig)((Object)((Object)e.getValue()))).getType().equals((Object)type)).filter(e -> isEnabled == null || isEnabled.booleanValue() == ((ExporterConfig)((Object)((Object)e.getValue()))).isEnabled() && isEnabled.booleanValue() == ((ExporterConfig)((Object)((Object)e.getValue()))).isMetricsEnabled()).filter(e -> names == null || names.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> castTo.cast(e.getValue())));
    }

    private static <T> Map<String, T> filterClientConfigMap(Map<String, ClientConfig> configNameMap, ClientConfig.ClientConfigType type, Boolean isEnabled, Set<String> names, Class<T> castTo) {
        return configNameMap.entrySet().stream().filter(e -> type == null || ((ClientConfig)((Object)((Object)e.getValue()))).getType().equals((Object)type)).filter(e -> names == null || names.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, e -> castTo.cast(e.getValue())));
    }

    static {
        CONFIG_EVENTS_ENABLE_DEFAULT = true;
        CONFIG_EVENTS_INCLUDE = Collections.unmodifiableList(Arrays.asList("transaction.remove.expired.transaction.cleanup.interval.ms", "transaction.state.log.load.buffer.size", "transaction.state.log.min.isr", "transaction.state.log.num.partitions", "transaction.state.log.replication.factor", "transaction.state.log.segment.bytes", "transactional.id.expiration.ms", "controlled.shutdown.enable", "fetch.max.bytes", "fetch.purgatory.purge.interval.requests", "group.initial.rebalance.delay.ms", "group.max.session.timeout.ms", "group.max.size", "group.min.session.timeout.ms", "log.cleaner.backoff.ms", "log.cleaner.dedupe.buffer.size", "log.cleaner.delete.retention.ms", "log.cleaner.enable", "log.cleaner.io.buffer.load.factor", "log.cleaner.io.buffer.size", "log.cleaner.io.max.bytes.per.second", "log.cleaner.max.compaction.lag.ms", "log.cleaner.min.cleanable.ratio", "log.cleaner.min.compaction.lag.ms", "log.cleaner.threads", "log.cleanup.policy", "log.index.interval.bytes", "log.index.size.max.bytes", "log.message.downconversion.enable", "log.message.format.version", "log.message.timestamp.difference.max.ms", "log.message.timestamp.type", "max.connection.creation.rate", "max.connections", "max.connections.per.ip", "max.incremental.fetch.session.cache.slots", "replica.fetch.backoff.ms", "replica.fetch.max.bytes", "replica.fetch.min.bytes", "replica.fetch.response.max.bytes", "replica.fetch.wait.max.ms", "replica.high.watermark.checkpoint.interval.ms", "replica.lag.time.max.ms", "replica.selector.class", "replica.socket.receive.buffer.bytes", "replica.socket.timeout.ms", "alter.config.policy.class.name", "alter.log.dirs.replication.quota.window.num", "alter.log.dirs.replication.quota.window.size.seconds", "metrics.num.samples", "metrics.recording.level", "metrics.sample.window.ms", "quota.window.num", "quota.window.size.seconds", "replication.quota.window.num", "replication.quota.window.size.seconds", "confluent.balancer.enable", "confluent.balancer.throttle.bytes.per.second", "confluent.balancer.heal.uneven.load.trigger", "confluent.balancer.heal.broker.failure.threshold.ms", "confluent.balancer.disk.max.load", "confluent.balancer.exclude.topic.prefixes", "confluent.balancer.exclude.topic.names", "confluent.tier.local.hotset.bytes", "confluent.tier.local.hotset.ms", "confluent.tier.archiver.num.threads", "confluent.tier.backend", "confluent.tier.enable", "confluent.tier.feature", "confluent.tier.fetcher.num.threads", "confluent.tier.max.partition.fetch.bytes.override", "confluent.tier.metadata.replication.factor", "confluent.operator.managed", "confluent.ansible.managed", "confluent.license"));
        DEFAULT_METRICS_INCLUDE = ConfluentTelemetryConfig.joinIncludeRegexList(Collections.singletonList(DEFAULT_SYSTEM_METRICS_INCLUDE_REGEX));
        CONFIG_EVENTS_INCLUDE_DEFAULT = ConfluentTelemetryConfig.joinIncludeRegexList(CONFIG_EVENTS_INCLUDE);
        DEFAULT_ACTIVE_FILTER_SET = Collections.singleton(DEFAULT_NAMED_FILTER_NAME);
        String procRoot = "/proc";
        Path loadAvgPath = Paths.get(procRoot, "loadavg");
        Path statPath = Paths.get(procRoot, "stat");
        boolean isLinuxCpuCollectorUsable = loadAvgPath.toFile().exists() && statPath.toFile().exists();
        log.info("Linux CPU collector enabled: {}", (Object)isLinuxCpuCollectorUsable);
        CPU_METRIC = isLinuxCpuCollectorUsable ? "io\\.confluent\\.kafka\\.server/server/linux_system_cpu_utilization_1m" : "io\\.confluent\\.system/jvm/os/process_cpu_load";
        log.info("Using cpu metric: {}", (Object)CPU_METRIC);
        EXPORTER_LOCAL_METRICS_INCLUDE = "(io\\.confluent\\.kafka\\.server/fetch/broker_quota|io\\.confluent\\.kafka\\.server/produce/broker_quota|io\\.confluent\\.kafka\\.server/broker_load/broker_load_percent|io\\.confluent\\.kafka\\.server/broker_topic/bytes_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/fetch_from_follower_bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/messages_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/replication_bytes_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/replication_bytes_out/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_fetch_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_follower_fetch_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/mirror_bytes_in/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_fetch_from_follower_requests/rate/1_min|io\\.confluent\\.kafka\\.server/broker_topic/total_produce_requests/rate/1_min|io\\.confluent\\.kafka\\.server/log/size|io\\.confluent\\.kafka\\.server/request/requests/rate/1_min|io\\.confluent\\.kafka\\.server/request_handler_pool/request_handler_avg_idle_percent/rate/1_min|" + CPU_METRIC + "|io\\.confluent\\.kafka\\.server/replica_manager/partition_count|io\\.confluent\\.system/volume/disk_total_bytes)";
        EXPORTER_LOCAL_DEFAULTS = ImmutableMap.of((Object)"type", (Object)ExporterConfig.ExporterType.kafka.name(), (Object)"enabled", (Object)true, (Object)"remote.configurable", (Object)false, (Object)"metrics.include", (Object)EXPORTER_LOCAL_METRICS_INCLUDE, (Object)"producer.bootstrap.servers", (Object)"localhost:9092", (Object)"producer.client.id", (Object)"confluent-telemetry-reporter-local-producer");
        EXPORTER_C3PLUSPLUS_DEFAULTS = ImmutableMap.of((Object)"type", (Object)ExporterConfig.ExporterType.http.name(), (Object)"metrics.include", (Object)EXPORTER_C3PLUSPLUS_METRICS_INCLUDE, (Object)"enabled", (Object)false, (Object)"client.base.url", (Object)"http://localhost:9090/api/v1/otlp", (Object)"client.compression", (Object)"gzip", (Object)"api.key", (Object)"unused", (Object)"api.secret", (Object)"unused", (Object)"buffer.inflight.submissions.max", (Object)10, (Object)"buffer.batch.items.max", (Object)2000, (Object)"buffer.pending.batches.max", (Object)25);
        EXPORTER_CONFLUENT_DEFAULTS = ImmutableMap.of((Object)"type", (Object)ExporterConfig.ExporterType.http.name(), (Object)"enabled", (Object)false, (Object)"client", (Object)CLIENT_CONFLUENT_NAME);
        CLIENT_CONFLUENT_DEFAULTS = ImmutableMap.of((Object)"type", (Object)ClientConfig.ClientConfigType.httpTelemetryClient.name(), (Object)"client.base.url", (Object)TELEMETRY_CONFLUENT_CLOUD_URL);
        EXPORTER_DEFAULT_CONFIGS = ImmutableMap.of((Object)EXPORTER_CONFLUENT_NAME, EXPORTER_CONFLUENT_DEFAULTS);
        CLIENT_DEFAULT_CONFIGS = ImmutableMap.of((Object)CLIENT_CONFLUENT_NAME, CLIENT_CONFLUENT_DEFAULTS);
        RECONFIGURABLES = ImmutableSet.of((Object)METRICS_INCLUDE_CONFIG, (Object)TELEMETRY_ENABLED_CONFIG, (Object)TELEMETRY_API_KEY, (Object)TELEMETRY_API_SECRET, (Object)TELEMETRY_PROXY_URL, (Object)TELEMETRY_PROXY_USERNAME, (Object[])new String[]{TELEMETRY_PROXY_PASSWORD, CONFIG_EVENTS_ENABLE_CONFIG});
        TRANSLATED_CONFIG_MAP = ImmutableMap.builder().put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "api.key"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "api.key")).put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "api.secret"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "api.secret")).put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.url"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.url")).put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.username"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.username")).put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "proxy.password"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.password")).put((Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "client.base.url"), (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "client.base.url")).build();
        RECONCILABLE_CONFIG_MAP = ImmutableMap.builder().put((Object)TELEMETRY_ENABLED_CONFIG, (Object)(ConfluentTelemetryConfig.exporterPrefixForName(EXPORTER_CONFLUENT_NAME) + "enabled")).put((Object)TELEMETRY_API_KEY, (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "api.key")).put((Object)TELEMETRY_API_SECRET, (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "api.secret")).put((Object)TELEMETRY_PROXY_URL, (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.url")).put((Object)TELEMETRY_PROXY_USERNAME, (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.username")).put((Object)TELEMETRY_PROXY_PASSWORD, (Object)(ConfluentTelemetryConfig.clientPrefixForName(CLIENT_CONFLUENT_NAME) + "proxy.password")).build();
        CONFIG = new ConfigDef().define(CLUSTER_ID_CONFIG, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, CLUSTER_ID_DOC).define(COLLECT_INTERVAL_CONFIG, ConfigDef.Type.LONG, (Object)DEFAULT_COLLECT_INTERVAL, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, COLLECT_INTERVAL_DOC).define(METRICS_INCLUDE_CONFIG, ConfigDef.Type.STRING, (Object)DEFAULT_METRICS_INCLUDE, (ConfigDef.Validator)new RegexConfigDefValidator("Metrics filter for configuration"), ConfigDef.Importance.LOW, METRICS_INCLUDE_DOC).define(SLO_COLLECTOR_ENABLED, ConfigDef.Type.BOOLEAN, (Object)DEFAULT_SLO_COLLECTOR_ENABLED, ConfigDef.Importance.LOW, SLO_COLLECTOR_DOC).define(CONFIG_EVENTS_INCLUDE_CONFIG, ConfigDef.Type.STRING, (Object)CONFIG_EVENTS_INCLUDE_DEFAULT, (ConfigDef.Validator)new RegexConfigDefValidator("Events filter for configuration"), ConfigDef.Importance.LOW, CONFIG_EVENTS_INCLUDE_DOC).define(CONFIG_EVENTS_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)CONFIG_EVENTS_ENABLE_DEFAULT, ConfigDef.Importance.LOW, CONFIG_EVENTS_ENABLE_DOC).define(DEBUG_ENABLED, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, DEBUG_ENABLED_DOC).define(TELEMETRY_API_KEY, ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, TELEMETRY_API_KEY_DOC).define(TELEMETRY_API_SECRET, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, TELEMETRY_API_SECRET_DOC).define(TELEMETRY_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, TELEMETRY_ENABLED_DOC).define(TELEMETRY_PROXY_URL, ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpConfigUtils.URIValidator(), ConfigDef.Importance.LOW, TELEMETRY_PROXY_URL_DOC).define(TELEMETRY_PROXY_USERNAME, ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, TELEMETRY_PROXY_USERNAME_DOC).define(TELEMETRY_PROXY_PASSWORD, ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, TELEMETRY_PROXY_PASSWORD_DOC).define(TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS, ConfigDef.Type.STRING, (Object)TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS_DEFAULT, ConfigDef.Importance.LOW, TELEMETRY_EXTERNAL_CLIENT_METRICS_EXCLUDE_LABELS_DOC);
    }
}

