/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.resource.v1.Resource;
import org.apache.kafka.common.utils.AppInfoParser;

public class Context {
    private final Resource resource;
    private final InstrumentationScope instrumentationScope;
    private final boolean debugEnabled;
    private final String domain;

    @VisibleForTesting
    public Context(String domain) {
        this(Resource.getDefaultInstance(), domain);
    }

    public Context(Resource resource, String domain) {
        this(resource, domain, false);
    }

    public Context(Resource resource, String domain, boolean debugEnabled) {
        this.resource = resource;
        this.debugEnabled = debugEnabled;
        this.domain = domain;
        this.instrumentationScope = InstrumentationScope.newBuilder().setName("io.confluent.TelemetryReporter").setVersion(AppInfoParser.getVersion() + "/" + AppInfoParser.getCommitId()).build();
    }

    public Resource getResource() {
        return this.resource;
    }

    public InstrumentationScope getInstrumentationScope() {
        return this.instrumentationScope;
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public String getDomain() {
        return this.domain;
    }
}

