/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.confluent.telemetry.metrics.Keyed;
import java.util.Map;
import java.util.Objects;

public class MetricKey
implements Keyed {
    private final String name;
    private final Map<String, String> labels;

    public MetricKey(String name, Map<String, String> labels) {
        this.name = Objects.requireNonNull(name, "name");
        this.labels = ImmutableMap.copyOf(labels);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricKey that = (MetricKey)o;
        return this.name.equals(that.name) && this.labels.equals(that.labels);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.labels);
    }

    public String toString() {
        return "MetricKey{name='" + this.name + "', labels=" + String.valueOf(this.labels) + "}";
    }

    @Override
    public MetricKey key() {
        return this;
    }

    public Builder toBuilder() {
        return MetricKey.newBuilder().setName(this.name).putLabels(this.labels);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private final ImmutableMap.Builder<String, String> labelsBuilder = ImmutableMap.builder();

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder putLabel(String key, String value) {
            this.labelsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public Builder putLabels(Map<String, String> labels) {
            this.labelsBuilder.putAll(labels);
            return this;
        }

        public Builder putLabels(String ... labels) {
            Preconditions.checkArgument((labels.length % 2 == 0 ? 1 : 0) != 0, (Object)"labels must be key-value pairs");
            for (int i = 0; i < labels.length; i += 2) {
                this.labelsBuilder.put((Object)labels[i], (Object)labels[i + 1]);
            }
            return this;
        }

        public MetricKey build() {
            return new MetricKey(this.name, (Map<String, String>)this.labelsBuilder.build());
        }
    }
}

