/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.base.Verify;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.config.v2.AggregationRule;
import io.confluent.telemetry.emitter.AggregatingEmitter;
import io.confluent.telemetry.emitter.Emitter;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.DefaultUncaughtExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsCollectorTask {
    private static final Logger log = LoggerFactory.getLogger(MetricsCollectorTask.class);
    private final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1);
    private final Collection<MetricsCollector> collectors;
    private final long collectIntervalMs;
    private final Emitter emitter;
    private volatile Set<AggregationRule> aggregationRules = Collections.emptySet();

    public MetricsCollectorTask(Collection<MetricsCollector> collectors, long collectIntervalMs, Emitter emitter) {
        Verify.verify((collectIntervalMs > 0L ? 1 : 0) != 0, (String)"collection interval cannot be less than 1", (Object[])new Object[0]);
        this.collectors = Objects.requireNonNull(collectors);
        this.collectIntervalMs = collectIntervalMs;
        this.emitter = emitter;
        this.executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        this.executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor.setThreadFactory(runnable -> {
            Thread thread = new Thread(runnable, "confluent-telemetry-metrics-collector-task-scheduler");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(log));
            return thread;
        });
    }

    public void setAggregationRules(Set<AggregationRule> aggregationRules) {
        this.aggregationRules = aggregationRules;
    }

    public void start() {
        this.schedule();
    }

    private void schedule() {
        this.executor.scheduleAtFixedRate(this::collectAndExport, this.collectIntervalMs, this.collectIntervalMs, TimeUnit.MILLISECONDS);
    }

    private void collectAndExport() {
        AggregatingEmitter aggregatingEmitter = new AggregatingEmitter(this.aggregationRules, this.emitter);
        for (MetricsCollector collector : this.collectors) {
            try {
                collector.collect(aggregatingEmitter);
            }
            catch (Throwable t) {
                log.error("Error while collecting metrics for collector = {})", (Object)collector, (Object)t);
            }
        }
        try {
            aggregatingEmitter.flushAggregates();
        }
        catch (Throwable t) {
            log.error("Error while flushing aggregates", t);
        }
    }

    public void close() {
        this.executor.shutdown();
    }
}

