/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.resource.v1.Resource;
import java.time.Clock;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class MetricsUtils {
    public static long toTimeUnixNanos(Instant t) {
        return TimeUnit.SECONDS.toNanos(t.getEpochSecond()) + (long)t.getNano();
    }

    public static Instant fromTimeUnixNanos(long t) {
        return Instant.ofEpochSecond(0L, t);
    }

    public static ZonedDateTime nowInUTC(Clock clock) {
        return Instant.now(clock).atZone(ZoneOffset.UTC);
    }

    public static OffsetDateTime nowInUTC() {
        return OffsetDateTime.now(Clock.systemUTC());
    }

    public static Map<String, String> attributesMap(Resource resource) {
        return MetricsUtils.attributesMap(resource.getAttributesList());
    }

    public static Map<String, String> attributesMap(List<KeyValue> attributes) {
        return attributes.stream().filter(attr -> attr.getValue().hasStringValue()).collect(Collectors.toMap(KeyValue::getKey, attr -> attr.getValue().getStringValue()));
    }

    public static List<NumberDataPoint> extractDataPoints(Metric metric) {
        switch (metric.getDataCase()) {
            case SUM: {
                return metric.getSum().getDataPointsList();
            }
            case GAUGE: {
                return metric.getGauge().getDataPointsList();
            }
        }
        return Collections.emptyList();
    }
}

