/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.confluent.telemetry.metrics.Keyed;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class PredicateUtils {
    public static final Predicate<Keyed> ALWAYS_TRUE = metricKey -> true;
    public static final Predicate<Keyed> ALWAYS_FALSE = metricKey -> false;
    public static final long MATCHER_CACHE_MAX_SIZE = 5000L;

    public static Predicate<Keyed> buildCachingMetricsPredicate(String regexString) {
        if ((regexString = regexString.trim()).isEmpty()) {
            return ALWAYS_TRUE;
        }
        final Pattern pattern = Pattern.compile(regexString);
        LoadingCache cache = CacheBuilder.newBuilder().maximumSize(5000L).concurrencyLevel(1).build((CacheLoader)new CacheLoader<String, Boolean>(){

            public Boolean load(String metricName) {
                return pattern.matcher(metricName).matches();
            }
        });
        return keyed -> (Boolean)cache.getUnchecked((Object)keyed.key().getName());
    }
}

