/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.confluent.telemetry.HostResourceLabelProvider;
import io.confluent.telemetry.JavaRuntimeResourceLabelProvider;
import io.confluent.telemetry.ResourceLabelProvider;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.ArrayValue;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.resource.v1.Resource;
import io.opentelemetry.proto.resource.v1.ResourceOrBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBuilderFacade {
    private static final Logger log = LoggerFactory.getLogger(ResourceBuilderFacade.class);
    private static final String KEY_VERSION = "version";
    private static final String KEY_ID = "id";
    private static final String TYPE = "type";
    private static final ImmutableList<ResourceLabelProvider> LABEL_PROVIDERS = ImmutableList.of((Object)new JavaRuntimeResourceLabelProvider(), (Object)new HostResourceLabelProvider());
    private final Resource.Builder resourceBuilder;
    private final String type;

    public ResourceBuilderFacade(String type) {
        this.type = Objects.requireNonNull(type, "Resource type must not be null").toLowerCase(Locale.ENGLISH);
        this.resourceBuilder = Resource.newBuilder();
        this.withLabel(TYPE, type);
        LABEL_PROVIDERS.forEach(provider -> this.withLabels(provider.getLabels()));
    }

    private static String prefixWithNamespace(String namespace, String labelKey) {
        return namespace + "." + labelKey;
    }

    public ResourceBuilderFacade withVersion(String version) {
        Objects.requireNonNull(version, "Version must not be null");
        return this.withNamespacedLabel(KEY_VERSION, version);
    }

    public ResourceBuilderFacade withId(String id) {
        Objects.requireNonNull(id, "ID must not be null");
        return this.withNamespacedLabel(KEY_ID, id);
    }

    public final ResourceBuilderFacade withLabel(String key, String value) {
        if (ResourceBuilderFacade.hasAttribute((ResourceOrBuilder)this.resourceBuilder, key)) {
            log.warn("Ignoring redefinition of existing telemetry label {}", (Object)key);
        } else {
            this.addAttribute(key, AnyValue.newBuilder().setStringValue(value));
        }
        return this;
    }

    public ResourceBuilderFacade withLabel(String key, List<String> values) {
        if (ResourceBuilderFacade.hasAttribute((ResourceOrBuilder)this.resourceBuilder, key)) {
            log.warn("Ignoring redefinition of existing telemetry label {}", (Object)key);
        } else {
            ArrayValue.Builder valuesBuilder = ArrayValue.newBuilder();
            values.stream().map(v -> AnyValue.newBuilder().setStringValue(v)).collect(Collectors.toList()).forEach(arg_0 -> ((ArrayValue.Builder)valuesBuilder).addValues(arg_0));
            this.addAttribute(key, AnyValue.newBuilder().setArrayValue(valuesBuilder));
        }
        return this;
    }

    private void addAttribute(String key, AnyValue.Builder value) {
        KeyValue.Builder kv = KeyValue.newBuilder().setKey(key).setValue(value);
        this.resourceBuilder.addAttributes(kv);
    }

    private static boolean hasAttribute(ResourceOrBuilder resource, String key) {
        return resource.getAttributesList().stream().anyMatch(kv -> kv.getKey().equals(key));
    }

    public final ResourceBuilderFacade withLabels(Map<String, String> labels) {
        labels.forEach(this::withLabel);
        return this;
    }

    public ResourceBuilderFacade withNamespacedLabel(String key, String value) {
        return this.withLabel(this.type + "." + key, value);
    }

    public ResourceBuilderFacade withNamespacedLabel(String key, List<String> values) {
        return this.withLabel(this.type + "." + key, values);
    }

    public ResourceBuilderFacade withNamespacedLabels(Map<String, String> labels) {
        labels.forEach(this::withNamespacedLabel);
        return this;
    }

    static void validate(ResourceOrBuilder resource) {
        Optional<String> type = resource.getAttributesList().stream().filter(kv -> TYPE.equals(kv.getKey()) && kv.getValue().hasStringValue()).map(kv -> kv.getValue().getStringValue()).findAny();
        Preconditions.checkState((boolean)type.isPresent(), (Object)"Resource type must be set");
        String versionLabel = ResourceBuilderFacade.prefixWithNamespace(type.get(), KEY_VERSION);
        Preconditions.checkState((boolean)ResourceBuilderFacade.hasAttribute(resource, versionLabel), (Object)"Resource version must be set");
        String idLabel = ResourceBuilderFacade.prefixWithNamespace(type.get(), KEY_ID);
        Preconditions.checkState((boolean)ResourceBuilderFacade.hasAttribute(resource, idLabel), (Object)"Resource ID must be set");
    }

    public Resource build() {
        ResourceBuilderFacade.validate((ResourceOrBuilder)this.resourceBuilder);
        return this.resourceBuilder.build();
    }
}

