/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.collector;

import com.google.common.base.CaseFormat;
import com.google.common.base.Strings;
import io.confluent.metrics.YammerMetricsUtils;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.collector.MetricNamingStrategy;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.kafka.common.MetricName;

public class ConfluentMetricNamingConvention {
    public static final String KAFKA_METRICS_LIB = "kafka";
    public static final String YAMMER_METRICS_LIB = "yammer";
    private static final String NAME_JOINER = "/";
    private static final Pattern KAFKA_METRIC_STATS1_PATTERN = Pattern.compile("_(kafka|metrics|stats)");
    private static final Pattern KAFKA_METRIC_STATS2_PATTERN = Pattern.compile("(kafka|metrics|stats)_");
    private static final Pattern PER_SEC_PATTERN = Pattern.compile("_per_sec");
    private static final Pattern ZOOKEEPER_PATTERN = Pattern.compile("zoo_keeper");
    private static final Pattern KSQL_GROUP_NAME_PATTERN = Pattern.compile("(ksql_engine_query|pull_query)$");

    public static MetricNamingStrategy<MetricName> forKafkaMetrics(final String domain, final boolean addOriginalName, final boolean addLibraryName) {
        return new MetricNamingStrategy<MetricName>(){

            @Override
            public MetricKey metricKey(MetricName metricName) {
                String group = Strings.nullToEmpty((String)metricName.group());
                String rawName = Strings.nullToEmpty((String)metricName.name());
                String name = ConfluentMetricNamingConvention.fullMetricName(domain, group, rawName);
                HashMap<String, String> labels = new HashMap<String, String>();
                if (addOriginalName) {
                    labels.put("metric_name_original", Strings.nullToEmpty((String)metricName.group()) + ":" + Strings.nullToEmpty((String)metricName.name()));
                }
                if (addLibraryName) {
                    labels.put("library", ConfluentMetricNamingConvention.KAFKA_METRICS_LIB);
                }
                labels.putAll(ConfluentMetricNamingConvention.cleanLabelNames(metricName.tags()));
                return new MetricKey(name, labels);
            }

            @Override
            public MetricKey derivedMetricKey(MetricKey key, String derivedComponent) {
                return new MetricKey(key.getName() + ConfluentMetricNamingConvention.NAME_JOINER + derivedComponent, key.getLabels());
            }
        };
    }

    public static MetricNamingStrategy<com.yammer.metrics.core.MetricName> forYammerMetrics(final String domain, final boolean addOriginalName, final boolean addLibraryName) {
        return new MetricNamingStrategy<com.yammer.metrics.core.MetricName>(){

            @Override
            public MetricKey metricKey(com.yammer.metrics.core.MetricName metricName) {
                String name = ConfluentMetricNamingConvention.fullMetricName(domain, metricName.getType(), metricName.getName());
                String mbeanName = Strings.nullToEmpty((String)metricName.getMBeanName());
                HashMap<String, String> labels = new HashMap<String, String>();
                if (addOriginalName) {
                    labels.put("metric_name_original", Strings.nullToEmpty((String)(metricName.getGroup() + ":" + metricName.getType() + ":" + metricName.getName())));
                }
                if (addLibraryName) {
                    labels.put("library", ConfluentMetricNamingConvention.YAMMER_METRICS_LIB);
                }
                labels.putAll(ConfluentMetricNamingConvention.cleanLabelNames(ConfluentMetricNamingConvention.filterYammerTags(YammerMetricsUtils.extractTags((String)mbeanName))));
                return new MetricKey(name, labels);
            }

            @Override
            public MetricKey derivedMetricKey(MetricKey key, String derivedComponent) {
                return new MetricKey(key.getName() + ConfluentMetricNamingConvention.NAME_JOINER + derivedComponent, key.getLabels());
            }
        };
    }

    public static MetricNamingStrategy<String> forAggregatedMetrics() {
        return new MetricNamingStrategy<String>(){

            @Override
            public MetricKey metricKey(String metricName) {
                return new MetricKey(metricName, Collections.emptyMap());
            }

            @Override
            public MetricKey derivedMetricKey(MetricKey key, String derivedComponent) {
                return new MetricKey(key.getName() + ConfluentMetricNamingConvention.NAME_JOINER + derivedComponent, key.getLabels());
            }
        };
    }

    private static Map<String, String> filterYammerTags(Map<String, String> tags) {
        tags.remove("name");
        tags.remove("type");
        return tags;
    }

    public static String convertCase(String raw) {
        CharSequence[] nameParts = raw.split("-");
        if (nameParts.length > 1) {
            for (int index = 0; index < nameParts.length; ++index) {
                nameParts[index] = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, (String)nameParts[index]);
            }
            raw = String.join((CharSequence)"-", nameParts);
        }
        String lowerHypenCase = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, raw);
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_UNDERSCORE, lowerHypenCase);
    }

    public static String fullMetricName(String domain, String group, String name) {
        return domain + NAME_JOINER + ConfluentMetricNamingConvention.cleanGroup(group) + NAME_JOINER + ConfluentMetricNamingConvention.cleanMetric(name);
    }

    private static String cleanGroup(String group) {
        Matcher matcher;
        if ((group = ConfluentMetricNamingConvention.clean(group)).startsWith("_confluent_ksql") && (matcher = KSQL_GROUP_NAME_PATTERN.matcher(group)).find()) {
            group = matcher.group();
        }
        return group;
    }

    private static String cleanMetric(String metric) {
        return ConfluentMetricNamingConvention.clean(metric);
    }

    public static Map<String, String> cleanLabelNames(Map<String, String> raw) {
        return raw.entrySet().stream().collect(Collectors.toMap(s -> ConfluentMetricNamingConvention.convertCase((String)s.getKey()), Map.Entry::getValue));
    }

    private static String clean(String raw) {
        String lowerHyphenCase = ConfluentMetricNamingConvention.convertCase(raw);
        return ZOOKEEPER_PATTERN.matcher(PER_SEC_PATTERN.matcher(KAFKA_METRIC_STATS2_PATTERN.matcher(KAFKA_METRIC_STATS1_PATTERN.matcher(lowerHyphenCase).replaceAll("")).replaceAll("")).replaceAll("")).replaceAll("zookeeper");
    }
}

