/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.collector;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.MetricKey;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;

public class LastValueTracker<T> {
    private final ConcurrentMap<MetricKey, AtomicReference<InstantAndValue<T>>> counters = new ConcurrentHashMap<MetricKey, AtomicReference<InstantAndValue<T>>>();

    public Optional<InstantAndValue<T>> getAndSet(MetricKey metricKey, Instant now, T value) {
        InstantAndValue<T> instantAndValue = new InstantAndValue<T>(now, value);
        AtomicReference<InstantAndValue<T>> valueOrNull = this.counters.putIfAbsent(metricKey, new AtomicReference<InstantAndValue<T>>(instantAndValue));
        if (valueOrNull == null) {
            return Optional.empty();
        }
        InstantAndValue<T> previousValue = valueOrNull.getAndSet(instantAndValue);
        return Optional.of(new InstantAndValue<T>(previousValue.getIntervalStart(), previousValue.getValue()));
    }

    public AtomicReference<InstantAndValue<T>> remove(MetricKey metricKey) {
        return (AtomicReference)this.counters.remove(metricKey);
    }

    public boolean contains(MetricKey metricKey) {
        return this.counters.containsKey(metricKey);
    }

    public static class InstantAndValue<T> {
        private final Instant intervalStart;
        private final T value;

        public InstantAndValue(Instant intervalStart, T value) {
            Preconditions.checkNotNull((Object)intervalStart, (Object)"intervalStart cannot be null");
            Preconditions.checkNotNull(value, (Object)"value cannot be null");
            this.intervalStart = intervalStart;
            this.value = value;
        }

        public Instant getIntervalStart() {
            return this.intervalStart;
        }

        public T getValue() {
            return this.value;
        }
    }
}

