/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.collector;

import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.MetricsRegistryListener;
import com.yammer.metrics.core.Summarizable;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.stats.Snapshot;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.collector.LastValueTracker;
import io.confluent.telemetry.collector.MetricNamingStrategy;
import io.confluent.telemetry.collector.MetricsCollector;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.metrics.SinglePointMetric;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.SummaryDataPoint;
import java.time.Clock;
import java.time.Instant;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YammerMetricsCollector
implements MetricsCollector {
    private static final Logger log = LoggerFactory.getLogger(YammerMetricsCollector.class);
    static final String DEFAULT_UNIT = "1";
    static final String NS_UNIT = "ns";
    private static final double[] QUANTILES = new double[]{0.5, 0.75, 0.95, 0.98, 0.99, 0.999};
    private final MetricsRegistry metricsRegistry;
    private final MetricNamingStrategy<MetricName> metricNamingStrategy;
    private final Clock clock;
    private final LastValueTracker<Long> longDeltas;
    private final LastValueTracker<Double> doubleDeltas;
    private final ConcurrentMap<MetricKey, Instant> metricAdded = new ConcurrentHashMap<MetricKey, Instant>();
    private final ConcurrentMap<MetricName, MetricKey> metricKeyCache = new ConcurrentHashMap<MetricName, MetricKey>();

    public YammerMetricsCollector(MetricsRegistry metricsRegistry, MetricNamingStrategy<MetricName> metricNamingStrategy, LastValueTracker<Long> longDeltas, LastValueTracker<Double> doubleDeltas, Clock clock) {
        this.metricsRegistry = metricsRegistry;
        this.metricNamingStrategy = metricNamingStrategy;
        this.clock = clock;
        this.longDeltas = longDeltas;
        this.doubleDeltas = doubleDeltas;
        this.setupMetricListener();
    }

    private void setupMetricListener() {
        this.metricsRegistry.addListener(new MetricsRegistryListener(){

            public void onMetricAdded(MetricName name, Metric metric) {
                YammerMetricsCollector.this.metricAdded.put(YammerMetricsCollector.this.toMetricKey(name), Instant.now(YammerMetricsCollector.this.clock));
            }

            public void onMetricRemoved(MetricName metricName) {
                MetricKey key = YammerMetricsCollector.this.toMetricKey(metricName);
                YammerMetricsCollector.this.longDeltas.remove(key);
                YammerMetricsCollector.this.doubleDeltas.remove(key);
                YammerMetricsCollector.this.metricAdded.remove(key);
                YammerMetricsCollector.this.metricKeyCache.remove(metricName);
            }
        });
    }

    MetricKey toMetricKey(MetricName metricName) {
        return this.metricKeyCache.computeIfAbsent(metricName, this.metricNamingStrategy::metricKey);
    }

    @Override
    public void collect(Emitter emitter) {
        Set metrics = this.metricsRegistry.allMetrics().entrySet();
        for (Map.Entry entry : metrics) {
            MetricName metricName = (MetricName)entry.getKey();
            Metric metric = (Metric)entry.getValue();
            try {
                this.collectMetric(emitter, metricName, metric);
            }
            catch (Exception e) {
                log.error("Unexpected error processing Yammer metric {}", (Object)metricName, (Object)e);
            }
        }
    }

    private void collectMetric(Emitter emitter, MetricName metricName, Metric metric) {
        MetricKey metricKey = this.toMetricKey(metricName);
        Instant metricAddedInstant = this.instantAdded(metricKey);
        log.trace("Processing {}", (Object)metricName);
        if (metric instanceof Gauge) {
            this.collectGauge(metricKey, ((Gauge)metric).value(), emitter);
        } else if (metric instanceof Counter) {
            long count = ((Counter)metric).count();
            this.collectSum(metricKey, count, metricAddedInstant, emitter);
            this.collectDelta(metricKey, count, metricAddedInstant, emitter);
        } else if (metric instanceof Meter) {
            Meter meter = (Meter)metric;
            long count = meter.count();
            double rateOneMinute = meter.oneMinuteRate();
            MetricKey totalKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "total");
            this.collectMeter(totalKey, count, metricAddedInstant, emitter);
            this.collectDelta(totalKey, count, metricAddedInstant, emitter);
            MetricKey rateKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "rate");
            MetricKey rate1MinKey = this.metricNamingStrategy.derivedMetricKey(rateKey, "1_min");
            this.collectGauge(rate1MinKey, rateOneMinute, emitter);
        } else if (metric instanceof Timer) {
            this.collectTimer(metricKey, (Timer)metric, emitter);
            MetricKey timeKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "time");
            this.collectDelta(timeKey, ((Timer)metric).sum(), metricAddedInstant, emitter);
            MetricKey totalKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "total");
            this.collectDelta(totalKey, ((Timer)metric).count(), metricAddedInstant, emitter);
        } else if (metric instanceof Histogram) {
            this.collectHistogram(metricKey, (Histogram)metric, emitter);
            MetricKey timeKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "time");
            this.collectDelta(timeKey, ((Histogram)metric).sum(), metricAddedInstant, emitter);
            MetricKey totalKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "total");
            this.collectDelta(totalKey, ((Histogram)metric).count(), metricAddedInstant, emitter);
        } else {
            log.debug("Unexpected metric type for {}", (Object)metricName);
        }
    }

    private Instant instantAdded(MetricKey metricKey) {
        return this.metricAdded.computeIfAbsent(metricKey, x -> this.clock.instant());
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    private void collectGauge(MetricKey metricKey, Object gaugeValue, Emitter emitter) {
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        if (gaugeValue instanceof Number) {
            emitter.emitMetric(SinglePointMetric.gauge(metricKey, (Number)gaugeValue, this.clock.instant()));
        } else if (gaugeValue instanceof Boolean) {
            emitter.emitMetric(SinglePointMetric.gauge(metricKey, (Boolean)gaugeValue != false ? 1L : 0L, this.clock.instant()));
        } else {
            log.debug("Ignoring {} value = {}", (Object)metricKey.getName(), gaugeValue);
        }
    }

    private void collectSum(MetricKey metricKey, long counterValue, Instant metricAdded, Emitter emitter) {
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        emitter.emitMetric(SinglePointMetric.cumulativeSum(metricKey, counterValue, this.clock.instant(), metricAdded));
    }

    private void collectDelta(MetricKey originalKey, long value, Instant metricAdded, Emitter emitter) {
        MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(originalKey, "delta");
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        Optional<LastValueTracker.InstantAndValue<Long>> lastValue = this.longDeltas.getAndSet(originalKey, this.clock.instant(), value);
        Instant start = metricAdded;
        long delta = value;
        if (lastValue.isPresent()) {
            start = lastValue.get().getIntervalStart();
            delta = value - lastValue.get().getValue();
        }
        emitter.emitMetric(SinglePointMetric.deltaSum(metricKey, delta, this.clock.instant(), start));
    }

    private void collectDelta(MetricKey originalKey, double value, Instant metricAdded, Emitter emitter) {
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return;
        }
        MetricKey metricKey = this.metricNamingStrategy.derivedMetricKey(originalKey, "delta");
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        Optional<LastValueTracker.InstantAndValue<Double>> lastValue = this.doubleDeltas.getAndSet(originalKey, this.clock.instant(), value);
        Instant start = metricAdded;
        double delta = value;
        if (lastValue.isPresent()) {
            start = lastValue.get().getIntervalStart();
            delta = value - lastValue.get().getValue();
        }
        emitter.emitMetric(SinglePointMetric.deltaSum(metricKey, delta, Instant.now(this.clock), start));
    }

    private void collectMeter(MetricKey metricKey, long meterCount, Instant metricAddedInstant, Emitter emitter) {
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        emitter.emitMetric(SinglePointMetric.cumulativeSum(metricKey, meterCount, this.clock.instant(), metricAddedInstant));
    }

    private void collectHistogram(MetricKey metricKey, Histogram histogram, Emitter emitter) {
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        Snapshot snapshot = histogram.getSnapshot();
        emitter.emitMetric(this.collectSnapshotAndCount(metricKey, DEFAULT_UNIT, snapshot, histogram.count(), (Summarizable)histogram));
        MetricKey p50Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p50");
        this.collectGauge(p50Key, snapshot.getValue(0.5), emitter);
        MetricKey p95Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p95");
        this.collectGauge(p95Key, snapshot.getValue(0.95), emitter);
        MetricKey p99Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p99");
        this.collectGauge(p99Key, snapshot.getValue(0.99), emitter);
        MetricKey p999Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p999");
        this.collectGauge(p999Key, snapshot.getValue(0.999), emitter);
        MetricKey maxKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "max");
        this.collectGauge(maxKey, histogram.max(), emitter);
    }

    private void collectTimer(MetricKey metricKey, Timer timer, Emitter emitter) {
        if (!emitter.shouldEmitMetric(metricKey)) {
            return;
        }
        Snapshot snapshot = timer.getSnapshot();
        emitter.emitMetric(this.collectSnapshotAndCount(metricKey, NS_UNIT, snapshot, timer.count(), (Summarizable)timer));
        MetricKey p50Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p50");
        this.collectGauge(p50Key, snapshot.getValue(0.5), emitter);
        MetricKey p95Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p95");
        this.collectGauge(p95Key, snapshot.getValue(0.95), emitter);
        MetricKey p99Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p99");
        this.collectGauge(p99Key, snapshot.getValue(0.99), emitter);
        MetricKey p999Key = this.metricNamingStrategy.derivedMetricKey(metricKey, "p999");
        this.collectGauge(p999Key, snapshot.getValue(0.999), emitter);
        MetricKey maxKey = this.metricNamingStrategy.derivedMetricKey(metricKey, "max");
        this.collectGauge(maxKey, timer.max(), emitter);
    }

    private SinglePointMetric collectSnapshotAndCount(MetricKey metricKey, String unit, Snapshot yammerSnapshot, long count, Summarizable summarizable) {
        SummaryDataPoint summary = SummaryDataPoint.newBuilder().setTimeUnixNano(MetricsUtils.toTimeUnixNanos(this.clock.instant())).addAllAttributes(SinglePointMetric.asAttributes(metricKey.getLabels())).setCount(count).setSum(summarizable.sum()).addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(0.0).setValue(summarizable.min())).addAllQuantileValues(Arrays.stream(QUANTILES).mapToObj(q -> SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(q).setValue(yammerSnapshot.getValue(q)).build())::iterator).addQuantileValues(SummaryDataPoint.ValueAtQuantile.newBuilder().setQuantile(1.0).setValue(summarizable.max())).build();
        Metric.Builder metric = io.opentelemetry.proto.metrics.v1.Metric.newBuilder().setName(metricKey.getName()).setUnit(unit);
        metric.getSummaryBuilder().addDataPoints(summary);
        return SinglePointMetric.create(metricKey, metric);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private MetricsRegistry metricsRegistry;
        private MetricNamingStrategy<MetricName> metricNamingStrategy;
        private Clock clock = Clock.systemUTC();
        private LastValueTracker<Long> longDeltas = new LastValueTracker();
        private LastValueTracker<Double> doubleDeltas = new LastValueTracker();

        private Builder() {
        }

        public Builder setMetricsRegistry(MetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            return this;
        }

        public Builder setMetricNamingStrategy(MetricNamingStrategy<MetricName> metricNamingStrategy) {
            this.metricNamingStrategy = metricNamingStrategy;
            return this;
        }

        public Builder setClock(Clock clock) {
            this.clock = Objects.requireNonNull(clock);
            return this;
        }

        public YammerMetricsCollector build() {
            Objects.requireNonNull(this.metricNamingStrategy);
            Objects.requireNonNull(this.metricsRegistry);
            return new YammerMetricsCollector(this.metricsRegistry, this.metricNamingStrategy, this.longDeltas, this.doubleDeltas, this.clock);
        }

        public Builder setLongDeltas(LastValueTracker<Long> longDeltas) {
            this.longDeltas = longDeltas;
            return this;
        }

        public Builder setDoubleDeltas(LastValueTracker<Double> doubleDeltas) {
            this.doubleDeltas = doubleDeltas;
            return this;
        }
    }
}

