/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import io.confluent.telemetry.config.v2.AdvancedNameFilter;
import io.confluent.telemetry.config.v2.AttributeRule;
import io.confluent.telemetry.config.v2.ExactMetricRule;
import io.confluent.telemetry.config.v2.PatternMetricRule;
import io.confluent.telemetry.metrics.Keyed;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

class AdvancedFilterPredicate
implements Predicate<Keyed> {
    private final Map<String, ExactMetricRule> exactRules;
    private final LoadingCache<String, Optional<PatternMetricRule>> patternMatchCache;

    AdvancedFilterPredicate(AdvancedNameFilter filter) {
        this.exactRules = Maps.uniqueIndex((Iterable)filter.getIncludeRules().getExactRules(), ExactMetricRule::getName);
        this.patternMatchCache = Optional.ofNullable(filter.getIncludeRules().getPatternRules()).map(patternRules -> CacheBuilder.newBuilder().maximumSize(5000L).concurrencyLevel(1).build(AdvancedFilterPredicate.newCacheLoader(patternRules))).orElse(null);
    }

    @Override
    public boolean test(Keyed keyed) {
        String metricName = keyed.key().getName();
        Map<String, String> attributes = keyed.key().getLabels();
        ExactMetricRule matchedExactRule = this.exactRules.get(metricName);
        if (matchedExactRule != null) {
            return this.testAttributes(matchedExactRule.getAttributeRules(), attributes, matchedExactRule.getAllowExtraAttributes());
        }
        if (this.patternMatchCache == null) {
            return false;
        }
        Optional matchedPatternRule = (Optional)this.patternMatchCache.getUnchecked((Object)metricName);
        if (matchedPatternRule.isPresent()) {
            PatternMetricRule rule = (PatternMetricRule)matchedPatternRule.get();
            return this.testAttributes(rule.getAttributeRules(), attributes, rule.getAllowExtraAttributes());
        }
        return false;
    }

    private boolean testAttributes(List<AttributeRule> rules, Map<String, String> attributes, boolean allowExtraAttributes) {
        HashMap<String, String> attributesCopy = new HashMap<String, String>(attributes);
        for (AttributeRule rule : rules) {
            String dataPointAttribute = (String)attributesCopy.remove(rule.getKey());
            if (dataPointAttribute != null && rule.getValues().contains(dataPointAttribute)) continue;
            return false;
        }
        return allowExtraAttributes || attributesCopy.isEmpty();
    }

    private static CacheLoader<String, Optional<PatternMetricRule>> newCacheLoader(final List<PatternMetricRule> patternRules) {
        return new CacheLoader<String, Optional<PatternMetricRule>>(){

            public Optional<PatternMetricRule> load(String metricName) throws Exception {
                for (PatternMetricRule patternRule : patternRules) {
                    if (!patternRule.getName().matcher(metricName).matches()) continue;
                    return Optional.of(patternRule);
                }
                return Optional.empty();
            }
        };
    }
}

