/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config;

import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.config.AdvancedFilterPredicate;
import io.confluent.telemetry.config.v2.AdvancedNameFilter;
import io.confluent.telemetry.config.v2.NamedFilter;
import io.confluent.telemetry.config.v2.SimpleNamedFilter;
import io.confluent.telemetry.metrics.Keyed;
import java.util.function.Predicate;

class NamedPredicate
implements Predicate<Keyed> {
    private final String name;
    private final Predicate<Keyed> delegate;

    public NamedPredicate(String name, Predicate<Keyed> delegate) {
        this.name = name;
        this.delegate = delegate;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public boolean test(Keyed keyed) {
        return this.delegate.test(keyed);
    }

    static NamedPredicate fromNamedFilter(NamedFilter filter) {
        if (filter instanceof SimpleNamedFilter) {
            SimpleNamedFilter f = (SimpleNamedFilter)filter;
            return new NamedPredicate(filter.getName(), PredicateUtils.buildCachingMetricsPredicate(f.getInclude()));
        }
        if (filter instanceof AdvancedNameFilter) {
            AdvancedNameFilter f = (AdvancedNameFilter)filter;
            return new NamedPredicate(filter.getName(), new AdvancedFilterPredicate(f));
        }
        throw new IllegalArgumentException(String.format("Unexpected named filter '%s' (type: %s)", filter.getName(), filter.getClass()));
    }
}

