/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.remote.file;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.telemetry.config.remote.file.FileRemoteConfigConfiguration;
import io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationSource;
import io.confluent.telemetry.config.v2.remote.RemoteConfiguration;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Optional;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileRemoteConfigSource
extends PollingRemoteConfigurationSource {
    private static final Logger log = LoggerFactory.getLogger(FileRemoteConfigSource.class);
    private static final ObjectMapper MAPPER = RemoteConfigurationSource.configureMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));
    private static final HashFunction HASH_FUNCTION = Hashing.goodFastHash((int)32);
    private final File file;
    private HashCode currentHash;

    public FileRemoteConfigSource(FileRemoteConfigConfiguration config, Consumer<RemoteConfiguration> callback) {
        super(config.getRefreshInterval(), callback);
        this.file = config.getFile();
    }

    @Override
    public void setConfigurationChangeCallback(Consumer<RemoteConfiguration> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Optional<RemoteConfiguration> requestConfig() {
        try {
            byte[] contents = Files.readAllBytes(this.file.toPath());
            HashCode hash = HASH_FUNCTION.hashBytes(contents);
            if (hash.equals((Object)this.currentHash)) {
                return Optional.empty();
            }
            this.currentHash = hash;
            log.debug("Loading TelemetryReporter \"remote\" config from local file: {}", (Object)this.file.getAbsolutePath());
            return Optional.of((RemoteConfiguration)MAPPER.readValue(contents, RemoteConfiguration.class));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

