/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.remote.polling;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.hubspot.jackson.datatype.protobuf.ProtobufModule;
import io.confluent.shaded.io.reactivex.Single;
import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.telemetry.client.TelemetryHttpResponse;
import io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationSource;
import io.confluent.telemetry.config.v2.remote.RemoteConfiguration;
import io.confluent.telemetry.config.v2.remote.RemoteConfigurationRequest;
import io.confluent.telemetry.config.v2.remote.RemoteConfigurationResponse;
import io.opentelemetry.proto.resource.v1.Resource;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

public class HttpRemoteConfigurationSource
extends PollingRemoteConfigurationSource {
    private static final String CONTENT_TYPE = "application/json";
    @VisibleForTesting
    public static final String V1_CONFIGURATION_ENDPOINT = "/v1/config";
    private final ObjectMapper mapper = RemoteConfigurationSource.configureMapper(new ObjectMapper()).registerModule((Module)new ProtobufModule());
    private final Resource resource;
    private final TelemetryHttpClient<RemoteConfigurationRequest, RemoteConfigurationResponse> httpClient;
    private volatile Credentials credentials;
    private volatile ProxyConfig proxyConfig;
    private RemoteConfigurationResponse latestResponse;

    public HttpRemoteConfigurationSource(TelemetryHttpClient.Builder<RemoteConfigurationRequest, RemoteConfigurationResponse> builder, long refreshIntervalMs, Consumer<RemoteConfiguration> callback, Resource resource) {
        super(refreshIntervalMs, callback);
        this.resource = resource;
        this.httpClient = builder.setEndpoint(V1_CONFIGURATION_ENDPOINT).setContentType(CONTENT_TYPE).setAcceptType(CONTENT_TYPE).setRequestSerializer((arg_0, arg_1) -> ((ObjectMapper)this.mapper).writeValue(arg_0, arg_1)).setResponseDeserializer(bytes -> (RemoteConfigurationResponse)this.mapper.readValue(bytes.array(), RemoteConfigurationResponse.class)).setCredentialsSupplier(() -> this.credentials).setProxyConfigSupplier(() -> this.proxyConfig).build();
    }

    @Override
    public void stop() {
        super.stop();
        try {
            this.httpClient.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    protected Optional<RemoteConfiguration> requestConfig() {
        if (this.credentials == null) {
            return Optional.empty();
        }
        Single result = this.httpClient.submit((Object)new RemoteConfigurationRequest(this.resource));
        RemoteConfigurationResponse response = (RemoteConfigurationResponse)((TelemetryHttpResponse)result.blockingGet()).getResponseBody();
        if (!(response.getChecksum() == null || this.latestResponse != null && Objects.equals(response.getChecksum(), this.latestResponse.getChecksum()))) {
            this.latestResponse = response;
            return Optional.ofNullable(response.getConfig());
        }
        return Optional.empty();
    }

    @VisibleForTesting
    void setLatestResponse(RemoteConfigurationResponse response) {
        this.latestResponse = response;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }
}

