/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.remote.polling.kubernetes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.annotations.VisibleForTesting;
import io.confluent.telemetry.config.remote.RemoteConfigurationSource;
import io.confluent.telemetry.config.remote.polling.kubernetes.V1Object;
import io.confluent.telemetry.config.v2.remote.RemoteConfiguration;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigSet {
    private static final Logger log = LoggerFactory.getLogger(ConfigSet.class);
    private static final ObjectMapper MAPPER = RemoteConfigurationSource.configureMapper(new ObjectMapper((JsonFactory)new YAMLFactory()));
    private final Set<ConfigSetEntry> configs;

    private ConfigSet(Set<ConfigSetEntry> configs) {
        this.configs = configs;
    }

    static ConfigSet parseConfigYaml(String configs) throws JsonProcessingException {
        return new ConfigSet((Set)MAPPER.readValue(configs, (TypeReference)new TypeReference<Set<ConfigSetEntry>>(){}));
    }

    static ConfigSet parseConfigYaml(V1Object object) throws JsonProcessingException {
        if ("ConfigMap".equals(object.getKind())) {
            return ConfigSet.parseConfigYaml(object.getData().get("configs"));
        }
        if ("Secret".equals(object.getKind())) {
            byte[] decodedBytes = Base64.getDecoder().decode(object.getData().get("configs"));
            return ConfigSet.parseConfigYaml(new String(decodedBytes, StandardCharsets.UTF_8));
        }
        throw new IllegalArgumentException("Unsupported object kind: " + object.getKind());
    }

    Optional<RemoteConfiguration> getCompatibleConfigVersion(String schemaVersion) {
        for (ConfigSetEntry entry : this.configs) {
            if (!ConfigSet.isVersionCompatible(schemaVersion, entry.getVersion())) continue;
            log.info("Using config version: " + entry.getVersion());
            return Optional.of((RemoteConfiguration)MAPPER.convertValue((Object)entry.getConfig(), RemoteConfiguration.class));
        }
        log.info("No compatible config versions found. Client Config Version {}. Found Config Versions: {}", (Object)schemaVersion, this.configs.stream().map(ConfigSetEntry::getVersion).collect(Collectors.toSet()));
        return Optional.empty();
    }

    private static boolean isVersionCompatible(String version, String versionToCompare) {
        int versionToCompareMajor;
        int versionInt = Integer.parseInt(version);
        return versionInt == (versionToCompareMajor = Integer.parseInt(versionToCompare.split("[.]")[0]));
    }

    ConfigSet merge(ConfigSet other) {
        HashSet<ConfigSetEntry> mergedConfigs = new HashSet<ConfigSetEntry>(this.configs);
        for (ConfigSetEntry otherEntry : other.configs) {
            Optional<ConfigSetEntry> existingEntry = mergedConfigs.stream().filter(entry -> entry.getVersion().equals(otherEntry.getVersion())).findFirst();
            if (existingEntry.isPresent()) {
                JsonNode mergedConfig = this.merge(existingEntry.get().getConfig(), otherEntry.getConfig());
                mergedConfigs.remove(existingEntry.get());
                mergedConfigs.add(new ConfigSetEntry(otherEntry.getVersion(), mergedConfig));
                continue;
            }
            mergedConfigs.add(otherEntry);
        }
        return new ConfigSet(mergedConfigs);
    }

    private JsonNode merge(JsonNode node1, JsonNode node2) {
        ObjectNode mergedNode = MAPPER.createObjectNode();
        node1.fields().forEachRemaining(entry -> mergedNode.set((String)entry.getKey(), (JsonNode)entry.getValue()));
        node2.fields().forEachRemaining(entry -> {
            String fieldName = (String)entry.getKey();
            JsonNode existingValue = mergedNode.get(fieldName);
            if (existingValue != null) {
                throw new IllegalStateException("Duplicate field found in remote configs: " + fieldName);
            }
            mergedNode.set(fieldName, (JsonNode)entry.getValue());
        });
        return mergedNode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSet configSet = (ConfigSet)o;
        return Objects.equals(this.configs, configSet.configs);
    }

    public int hashCode() {
        return Objects.hash(this.configs);
    }

    @VisibleForTesting
    static class ConfigSetEntry {
        private final String version;
        private final JsonNode config;

        @JsonCreator
        public ConfigSetEntry(@JsonProperty(value="version") String version, @JsonProperty(value="value") JsonNode config) {
            this.version = version;
            this.config = config;
        }

        public String getVersion() {
            return this.version;
        }

        public JsonNode getConfig() {
            return this.config;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigSetEntry that = (ConfigSetEntry)o;
            return Objects.equals(this.version, that.version) && Objects.equals(this.config, that.config);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.config);
        }
    }
}

