/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.config.remote.polling.kubernetes;

import io.confluent.telemetry.config.remote.polling.PollingRemoteConfigurationConfig;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.config.ConfigDef;

public class KubernetesRemoteConfigurationConfig
extends PollingRemoteConfigurationConfig {
    public static final String NAMESPACE_CONFIG = "namespace";
    public static final String DEFAULT_NAMESPACE = "telemetry-config";
    public static final String NAMESPACE_DOC = "The configured KubernetesRemoteConfiguration will watch for Secret/ConfigMap changes in this configured namespace";
    public static final String CONFIG_MAP_NAME_CONFIG = "configmap.name";
    public static final String CONFIG_MAP_NAME_DOC = "The name of the Kubernetes Secret/ConfigMap to watch for changes to remotely configure if the override cluster named Secret/ConfigMap is not present";
    public static final String CONNECT_TIMEOUT_MS_CONFIG = "connect.timeout.ms";
    public static final Long DEFAULT_CONNECT_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final String CONNECT_TIMEOUT_MS_DOC = "The timeout value, in milliseconds, to be used when opening a connection to the k8s resource.";
    public static final String READ_TIMEOUT_MS_CONFIG = "read.timeout.ms";
    public static final Long DEFAULT_READ_TIMEOUT = TimeUnit.SECONDS.toMillis(30L);
    public static final String READ_TIMEOUT_MS_DOC = "The timeout value, in milliseconds, to be used when reading from an input stream when a connection to the k8s resource is established.";
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("namespace", ConfigDef.Type.STRING, (Object)"telemetry-config", ConfigDef.Importance.LOW, "The configured KubernetesRemoteConfiguration will watch for Secret/ConfigMap changes in this configured namespace").define("configmap.name", ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.MEDIUM, "The name of the Kubernetes Secret/ConfigMap to watch for changes to remotely configure if the override cluster named Secret/ConfigMap is not present").define("connect.timeout.ms", ConfigDef.Type.INT, (Object)DEFAULT_CONNECT_TIMEOUT.intValue(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The timeout value, in milliseconds, to be used when opening a connection to the k8s resource.").define("read.timeout.ms", ConfigDef.Type.INT, (Object)DEFAULT_READ_TIMEOUT.intValue(), (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "The timeout value, in milliseconds, to be used when reading from an input stream when a connection to the k8s resource is established.");

    public KubernetesRemoteConfigurationConfig(Map<?, ?> originals, boolean doLog) {
        super(CONFIG_DEF, originals, doLog);
    }

    String getNamespace() {
        return this.getString(NAMESPACE_CONFIG);
    }

    String getConfigMapNameConfig() {
        return this.getString(CONFIG_MAP_NAME_CONFIG);
    }

    int getConnectTimeout() {
        return this.getInt(CONNECT_TIMEOUT_MS_CONFIG);
    }

    int getReadTimeout() {
        return this.getInt(READ_TIMEOUT_MS_CONFIG);
    }
}

