/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.telemetry.config.v2.AggregationRule;
import io.confluent.telemetry.emitter.Aggregator;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.metrics.SinglePointMetric;
import java.util.Set;

public class AggregatingEmitter
implements Emitter {
    private final Aggregator aggregator;
    private final Emitter delegate;

    public AggregatingEmitter(Set<AggregationRule> aggregationRule, Emitter delegate) {
        this.aggregator = new Aggregator(aggregationRule);
        this.delegate = delegate;
    }

    @Override
    public boolean shouldEmitMetric(Keyed key) {
        return this.delegate.shouldEmitMetric(key);
    }

    @Override
    public boolean emitMetric(SinglePointMetric metric) {
        if (this.aggregator.accumulate(metric)) {
            return false;
        }
        return this.delegate.emitMetric(metric);
    }

    public void flushAggregates() {
        this.aggregator.getAggregates().forEach(this.delegate::emitMetric);
    }
}

