/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.collector.ConfluentMetricNamingConvention;
import io.confluent.telemetry.collector.MetricNamingStrategy;
import io.confluent.telemetry.config.v2.AggregationRule;
import io.confluent.telemetry.metrics.SinglePointMetric;
import io.opentelemetry.proto.metrics.v1.AggregationTemporality;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.MetricOrBuilder;
import io.opentelemetry.proto.metrics.v1.NumberDataPointOrBuilder;
import java.time.Instant;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Aggregator {
    private static final Logger LOGGER = LoggerFactory.getLogger(Aggregator.class);
    private static final Set<AggregationRule.Operator> GAUGE_SUPPORTED_OPS = EnumSet.of(AggregationRule.Operator.avg, AggregationRule.Operator.min, AggregationRule.Operator.max, AggregationRule.Operator.sum, AggregationRule.Operator.count);
    private final Set<AggregationRule> rules;
    private final Map<MetricKey, Accumulation> aggregates = new ConcurrentHashMap<MetricKey, Accumulation>();

    Aggregator(Set<AggregationRule> rules) {
        this.rules = rules;
    }

    boolean accumulate(SinglePointMetric metric) {
        AggregationRule rule = this.lookupRule(metric.key());
        if (rule == null) {
            return false;
        }
        Metric.Builder otelMetric = metric.metric();
        if (!this.isSupported(rule, (MetricOrBuilder)otelMetric)) {
            return false;
        }
        MetricKey aggregationKey = this.reduceKey(rule, metric.key());
        this.aggregates.compute(aggregationKey, (arg_0, arg_1) -> this.lambda$accumulate$0((MetricOrBuilder)otelMetric, rule, arg_0, arg_1));
        return true;
    }

    private Accumulation accumulateSum(MetricOrBuilder otelMetric, Accumulation current, AggregationRule rule) {
        return this.accumulate(otelMetric.getSumOrBuilder().getDataPointsOrBuilder(0), current, rule, Metric.DataCase.SUM);
    }

    private Accumulation accumulateGauge(MetricOrBuilder otelMetric, Accumulation current, AggregationRule rule) {
        return this.accumulate(otelMetric.getGaugeOrBuilder().getDataPointsOrBuilder(0), current, rule, Metric.DataCase.GAUGE);
    }

    private Accumulation accumulate(NumberDataPointOrBuilder point, Accumulation current, AggregationRule rule, Metric.DataCase datacase) {
        if (current == null) {
            return point.hasAsDouble() || datacase == Metric.DataCase.GAUGE && rule.getOperator() == AggregationRule.Operator.avg ? new DoubleAccumulation(point, rule, datacase) : new LongAccumulation(point, rule, datacase);
        }
        current.accumulate(point);
        return current;
    }

    private MetricKey reduceKey(AggregationRule rule, MetricKey originalKey) {
        MetricKey.Builder builder = MetricKey.newBuilder().setName(rule.getMetric());
        rule.getAttributes().forEach(attribute -> {
            if (originalKey.getLabels().containsKey(attribute)) {
                builder.putLabels((String)attribute, originalKey.getLabels().get(attribute));
            }
        });
        return builder.build();
    }

    private AggregationRule lookupRule(MetricKey key) {
        return this.rules.stream().filter(rule -> rule.getMetric().equals(key.getName())).findFirst().orElse(null);
    }

    private boolean isSupported(AggregationRule rule, MetricOrBuilder metric) {
        return this.isSupportedSum(rule, metric) || this.isSupportedGauge(rule, metric);
    }

    private boolean isSupportedSum(AggregationRule rule, MetricOrBuilder metric) {
        return rule.getOperator() == AggregationRule.Operator.sum && metric.hasSum() && metric.getSum().getAggregationTemporality() == AggregationTemporality.AGGREGATION_TEMPORALITY_DELTA;
    }

    private boolean isSupportedGauge(AggregationRule rule, MetricOrBuilder metric) {
        return metric.hasGauge() && GAUGE_SUPPORTED_OPS.contains(rule.getOperator());
    }

    Stream<SinglePointMetric> getAggregates() {
        return this.aggregates.entrySet().stream().map(entry -> ((Accumulation)entry.getValue()).constructMetric((MetricKey)entry.getKey()));
    }

    private /* synthetic */ Accumulation lambda$accumulate$0(MetricOrBuilder otelMetric, AggregationRule rule, MetricKey k, Accumulation current) {
        switch (otelMetric.getDataCase()) {
            case SUM: {
                return this.accumulateSum(otelMetric, current, rule);
            }
            case GAUGE: {
                return this.accumulateGauge(otelMetric, current, rule);
            }
        }
        LOGGER.error("Unsupported metric type for aggregation: {}", (Object)otelMetric.getDataCase());
        return current;
    }

    static abstract class Accumulation {
        static final MetricNamingStrategy<String> METRIC_NAMING_STRATEGY = ConfluentMetricNamingConvention.forAggregatedMetrics();
        final Instant start;
        final Instant end;
        final AggregationRule.Operator operator;
        final Metric.DataCase datacase;
        final String outputName;
        int numDatapoints;

        Accumulation(NumberDataPointOrBuilder point, AggregationRule rule, Metric.DataCase datacase) {
            this.start = MetricsUtils.fromTimeUnixNanos(point.getStartTimeUnixNano());
            this.end = MetricsUtils.fromTimeUnixNanos(point.getTimeUnixNano());
            this.operator = rule.getOperator();
            this.datacase = datacase;
            this.numDatapoints = 1;
            this.outputName = rule.getOutputName();
        }

        abstract void accumulate(NumberDataPointOrBuilder var1);

        abstract SinglePointMetric constructMetric(MetricKey var1);
    }

    static class DoubleAccumulation
    extends Accumulation {
        private double value;

        DoubleAccumulation(NumberDataPointOrBuilder point, AggregationRule rule, Metric.DataCase datacase) {
            super(point, rule, datacase);
            this.value = this.operator == AggregationRule.Operator.count ? 1.0 : (point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt());
        }

        @Override
        public void accumulate(NumberDataPointOrBuilder point) {
            double valueToAccumulate;
            double d = valueToAccumulate = point.hasAsDouble() ? point.getAsDouble() : (double)point.getAsInt();
            if (Double.isNaN(valueToAccumulate)) {
                return;
            }
            ++this.numDatapoints;
            switch (this.operator) {
                case avg: {
                    this.value += (valueToAccumulate - this.value) / (double)this.numDatapoints;
                    break;
                }
                case min: {
                    this.value = Math.min(this.value, valueToAccumulate);
                    break;
                }
                case max: {
                    this.value = Math.max(this.value, valueToAccumulate);
                    break;
                }
                case sum: {
                    this.value += valueToAccumulate;
                    break;
                }
                case count: {
                    this.value += 1.0;
                    break;
                }
                default: {
                    LOGGER.error("Unsupported aggregation operator: {}", (Object)this.operator);
                }
            }
        }

        @Override
        SinglePointMetric constructMetric(MetricKey key) {
            MetricKey finalMetricKey = key;
            if (this.outputName != null) {
                finalMetricKey = key.toBuilder().setName(this.outputName).build();
            } else if (this.datacase == Metric.DataCase.GAUGE) {
                switch (this.operator) {
                    case avg: {
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "avg");
                        break;
                    }
                    case min: {
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "min");
                        break;
                    }
                    case max: {
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "max");
                        break;
                    }
                    case count: {
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "count");
                        break;
                    }
                    default: {
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "sum");
                    }
                }
            }
            switch (this.datacase) {
                case GAUGE: {
                    return SinglePointMetric.gauge(finalMetricKey, this.value, this.end);
                }
            }
            return SinglePointMetric.deltaSum(finalMetricKey, this.value, this.end, this.start);
        }
    }

    static class LongAccumulation
    extends Accumulation {
        private long value;

        LongAccumulation(NumberDataPointOrBuilder point, AggregationRule rule, Metric.DataCase datacase) {
            super(point, rule, datacase);
            this.value = this.operator == AggregationRule.Operator.count ? 1L : point.getAsInt();
        }

        @Override
        public void accumulate(NumberDataPointOrBuilder point) {
            ++this.numDatapoints;
            switch (this.operator) {
                case min: {
                    this.value = Math.min(this.value, point.getAsInt());
                    break;
                }
                case max: {
                    this.value = Math.max(this.value, point.getAsInt());
                    break;
                }
                case sum: {
                    this.value += point.getAsInt();
                    break;
                }
                case count: {
                    ++this.value;
                    break;
                }
                default: {
                    LOGGER.error("Unsupported aggregation operator: {}", (Object)this.operator);
                }
            }
        }

        @Override
        SinglePointMetric constructMetric(MetricKey key) {
            MetricKey finalMetricKey = key;
            if (this.outputName != null) {
                finalMetricKey = key.toBuilder().setName(this.outputName).build();
            } else {
                block0 : switch (this.datacase) {
                    case GAUGE: {
                        switch (this.operator) {
                            case min: {
                                finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "min");
                                break block0;
                            }
                            case max: {
                                finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "max");
                                break block0;
                            }
                            case count: {
                                finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "count");
                                break block0;
                            }
                        }
                        finalMetricKey = METRIC_NAMING_STRATEGY.derivedMetricKey(key, "sum");
                    }
                }
            }
            switch (this.datacase) {
                case GAUGE: {
                    return SinglePointMetric.gauge(finalMetricKey, this.value, this.end);
                }
            }
            return SinglePointMetric.deltaSum(finalMetricKey, this.value, this.end, this.start);
        }
    }
}

