/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.telemetry.Context;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.emitter.ClientLabels;
import io.confluent.telemetry.emitter.ContextExportableMetric;
import io.opentelemetry.proto.common.v1.AnyValue;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.common.v1.KeyValue;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ClientExportableMetric
extends ContextExportableMetric {
    private final Resource clientResource;
    private final Map<String, String> brokerMetricsLabels;
    private final Map<String, String> requestLabels;
    private final Set<String> excludeLabels;

    public ClientExportableMetric(Metric metric, MetricKey key, Context context, Resource clientResource, Map<String, String> brokerMetricsLabels, Map<String, String> requestLabels, Set<String> excludeLabels) {
        super(metric, key, context);
        this.clientResource = clientResource;
        this.brokerMetricsLabels = brokerMetricsLabels;
        this.requestLabels = requestLabels;
        this.excludeLabels = excludeLabels;
    }

    @Override
    public Metric metric() {
        return ClientExportableMetric.updateMetricDataPoint(super.metric(), this.requestLabels, this.brokerMetricsLabels, this.clientResource, this.excludeLabels);
    }

    @Override
    public ResourceMetrics resourceMetrics() {
        return ClientExportableMetric.buildResourceMetric(super.metric(), this.clientResource, this.brokerMetricsLabels, this.requestLabels, this.instrumentationScope());
    }

    private static Metric updateMetricDataPoint(Metric metric, Map<String, String> requestLabels, Map<String, String> brokerMetricsLabels, Resource resource, Set<String> excludeLabels) {
        NumberDataPoint numberDataPoint = MetricsUtils.extractDataPoints(metric).get(0);
        HashMap<String, String> allLabels = new HashMap<String, String>();
        for (KeyValue keyValue : numberDataPoint.getAttributesList()) {
            ClientLabels.putIfNotNull(allLabels, keyValue.getKey(), keyValue.getValue().getStringValue());
        }
        for (KeyValue keyValue : resource.getAttributesList()) {
            ClientLabels.putIfNotNull(allLabels, keyValue.getKey(), keyValue.getValue().getStringValue());
        }
        allLabels.putAll(requestLabels);
        allLabels.putAll(brokerMetricsLabels);
        NumberDataPoint.Builder updatedDataPointBuilder = numberDataPoint.toBuilder().clearAttributes();
        allLabels.forEach((key, value) -> {
            if (!excludeLabels.contains(key)) {
                updatedDataPointBuilder.addAttributes(KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue(value)).build());
            }
        });
        return ClientExportableMetric.constructMetricWithDataPoint(metric, updatedDataPointBuilder).build();
    }

    private static Metric.Builder constructMetricWithDataPoint(Metric metric, NumberDataPoint.Builder dataPointBuilder) {
        Metric.Builder updatedMetric = metric.toBuilder();
        if (metric.getDataCase() == Metric.DataCase.SUM) {
            updatedMetric.setSum(metric.getSum().toBuilder().clearDataPoints().addDataPoints(dataPointBuilder));
        } else {
            updatedMetric.setGauge(metric.getGauge().toBuilder().clearDataPoints().addDataPoints(dataPointBuilder));
        }
        return updatedMetric;
    }

    private static ResourceMetrics buildResourceMetric(Metric metric, Resource resource, Map<String, String> brokerMetricsLabels, Map<String, String> requestLabels, InstrumentationScope instrumentationScope) {
        HashMap<String, String> allLabels = new HashMap<String, String>();
        for (KeyValue keyValue : resource.getAttributesList()) {
            if (!ClientLabels.METRICS_LABELS_MAPPING.containsKey(keyValue.getKey())) continue;
            ClientLabels.putIfNotNull(allLabels, ClientLabels.METRICS_LABELS_MAPPING.get(keyValue.getKey()), keyValue.getValue().getStringValue());
        }
        NumberDataPoint numberDataPoint = MetricsUtils.extractDataPoints(metric).get(0);
        List attributesList = numberDataPoint.getAttributesList();
        for (KeyValue keyValue : attributesList) {
            if (!ClientLabels.METRICS_LABELS_MAPPING.containsKey(keyValue.getKey())) continue;
            ClientLabels.putIfNotNull(allLabels, ClientLabels.METRICS_LABELS_MAPPING.get(keyValue.getKey()), keyValue.getValue().getStringValue());
        }
        allLabels.putAll(requestLabels);
        allLabels.putAll(brokerMetricsLabels);
        Resource.Builder updatedResource = resource.toBuilder().clearAttributes();
        ClientLabels.RESOURCE_LABEL_KEYS.stream().filter(allLabels::containsKey).forEach(key -> updatedResource.addAttributes(KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue((String)allLabels.get(key))).build()));
        NumberDataPoint.Builder updatedDataPointBuilder = numberDataPoint.toBuilder().clearAttributes();
        ClientLabels.METRICS_LABEL_KEYS.stream().filter(allLabels::containsKey).forEach(key -> updatedDataPointBuilder.addAttributes(KeyValue.newBuilder().setKey(key).setValue(AnyValue.newBuilder().setStringValue((String)allLabels.get(key)).build()).build()));
        Metric.Builder updatedMetric = ClientExportableMetric.constructMetricWithDataPoint(metric, updatedDataPointBuilder);
        return ResourceMetrics.newBuilder().setResource(updatedResource).addScopeMetrics(ScopeMetrics.newBuilder().setScope(instrumentationScope).addMetrics(updatedMetric).build()).build();
    }
}

