/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;

public class ClientLabels {
    static final String CLIENT_PREFIX = "client_external.";
    static final String CLIENT_ID = "client_external.client.id";
    static final String CLIENT_INSTANCE_ID = "client_external.client.instance.id";
    static final String CLIENT_SOURCE_ADDRESS = "client_external.client.source.address";
    static final String CLIENT_SOURCE_PORT = "client_external.client.source.port";
    static final String PRINCIPAL = "client_external.principal";
    static final String CLUSTER_ID = "client_external.kafka.cluster.id";
    static final String GROUP_MEMBER_ID_KEY = "client_external.group.member.id";
    static final String NODE_ID = "client_external.node.id";
    static final String PROCESS_ID = "client_external.stream.process.id";
    static final String THREAD_ID = "client_external.stream.thread.id";
    static final String TRANSACTIONAL_ID_KEY = "client_external.transactional.id";
    static final String RACK_NAME = "client_external.client.rack";
    static final String GROUP_ID_KEY = "client_external.group.id";
    static final String PHYSICAL_CLUSTER_ID = "physical_cluster_id";
    static final String RESOURCE_BROKER_ID = "kafka.broker.id";
    static final String KAFKA_VERSION = "kafka.version";
    static final String APP = "app";
    static final String CLIENT_EXTERNAL_RESOURCE_VALUE = "client_external";
    static final Set<String> RESOURCE_LABEL_KEYS = ImmutableSet.of((Object)"client_external.client.id", (Object)"client_external.client.instance.id", (Object)"client_external.client.source.address", (Object)"client_external.client.source.port", (Object)"client_external.principal", (Object)"client_external.kafka.cluster.id", (Object[])new String[]{"kafka.broker.id", "client_external.group.member.id", "client_external.node.id", "client_external.stream.process.id", "client_external.stream.thread.id", "client_external.transactional.id", "client_external.client.rack", "client_external.group.id", "physical_cluster_id", "kafka.version", "app"});
    static final String CLIENT_SOFTWARE_NAME = "client_software_name";
    static final String CLIENT_SOFTWARE_VERSION = "client_software_version";
    static final String TENANT = "logical_cluster_id";
    static final String TOPIC = "tenant_topic";
    static final String TENANT_NAME = "tenant";
    static final String BROKER_ID = "broker_id";
    static final String USER = "user";
    static final String USER_RESOURCE_ID = "user_resource_id";
    static final String GROUP_INSTANCE_ID_KEY = "group_instance_id";
    static final Set<String> METRICS_LABEL_KEYS = ImmutableSet.of((Object)"client_software_name", (Object)"client_software_version", (Object)"logical_cluster_id", (Object)"tenant_topic", (Object)"tenant", (Object)"broker_id", (Object[])new String[]{"user", "user_resource_id", "group_instance_id"});
    static final Map<String, String> METRICS_LABELS_MAPPING = ImmutableMap.of((Object)"topic", (Object)"tenant_topic", (Object)"group_member_id", (Object)"client_external.group.member.id", (Object)"group_instance_id", (Object)"group_instance_id", (Object)"group_id", (Object)"client_external.group.id", (Object)"transactional_id", (Object)"client_external.transactional.id", (Object)"client_rack", (Object)"client_external.client.rack", (Object)"node_id", (Object)"client_external.node.id", (Object)"process_id", (Object)"client_external.stream.process.id", (Object)"thread_id", (Object)"client_external.stream.thread.id");

    static Map<String, String> getClientRequestLabels(AuthorizableRequestContext context, String clientInstanceId) {
        HashMap<String, String> labels = new HashMap<String, String>();
        ClientLabels.putIfNotNull(labels, CLIENT_ID, context.clientId());
        ClientLabels.putIfNotNull(labels, CLIENT_INSTANCE_ID, clientInstanceId);
        ClientLabels.putIfNotNull(labels, CLIENT_SOURCE_ADDRESS, context.clientAddress().getHostAddress());
        ClientLabels.putIfNotNull(labels, PRINCIPAL, context.principal().getName());
        if (context instanceof RequestContext) {
            RequestContext requestContext = (RequestContext)context;
            ClientLabels.putIfNotNull(labels, CLIENT_SOFTWARE_NAME, requestContext.clientInformation.softwareName());
            ClientLabels.putIfNotNull(labels, CLIENT_SOFTWARE_VERSION, requestContext.clientInformation.softwareVersion());
            ClientLabels.putIfNotNull(labels, CLIENT_SOURCE_PORT, Integer.toString(requestContext.clientPort.orElse(-1)));
        }
        if (context.principal() instanceof MultiTenantPrincipal) {
            ClientLabels.putIfNotNull(labels, USER, ((MultiTenantPrincipal)context.principal()).user());
            ClientLabels.putIfNotNull(labels, USER_RESOURCE_ID, ((MultiTenantPrincipal)context.principal()).tenantMetadata().userResourceId);
            ClientLabels.putIfNotNull(labels, TENANT, ((MultiTenantPrincipal)context.principal()).tenantMetadata().tenantName);
            ClientLabels.putIfNotNull(labels, TENANT_NAME, ((MultiTenantPrincipal)context.principal()).tenantMetadata().tenantName);
        }
        return Collections.unmodifiableMap(labels);
    }

    static Map<String, String> getBrokerLabels(Map<String, String> rawLabels) {
        HashMap<String, String> labels = new HashMap<String, String>();
        ClientLabels.putIfNotNull(labels, PHYSICAL_CLUSTER_ID, rawLabels.get("kafka.physical_cluster_id"));
        ClientLabels.putIfNotNull(labels, BROKER_ID, rawLabels.get(RESOURCE_BROKER_ID));
        ClientLabels.putIfNotNull(labels, RESOURCE_BROKER_ID, rawLabels.get(RESOURCE_BROKER_ID));
        ClientLabels.putIfNotNull(labels, CLUSTER_ID, rawLabels.get("kafka.cluster.id"));
        ClientLabels.putIfNotNull(labels, KAFKA_VERSION, rawLabels.get(KAFKA_VERSION));
        ClientLabels.putIfNotNull(labels, APP, CLIENT_EXTERNAL_RESOURCE_VALUE);
        return Collections.unmodifiableMap(labels);
    }

    public static void putIfNotNull(Map<String, String> map, String key, String value) {
        if (value != null) {
            map.put(key, value);
        }
    }
}

