/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import io.confluent.telemetry.Context;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.MetricsUtils;
import io.confluent.telemetry.emitter.ClientExportableMetric;
import io.confluent.telemetry.emitter.ClientLabels;
import io.confluent.telemetry.emitter.TelemetryEmitter;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import io.opentelemetry.proto.metrics.v1.NumberDataPoint;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.telemetry.ClientTelemetryPayload;
import org.apache.kafka.server.telemetry.ClientTelemetryReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientMetricsTelemetryReceiver
implements ClientTelemetryReceiver {
    private static final Logger log = LoggerFactory.getLogger(ClientMetricsTelemetryReceiver.class);
    private final TelemetryEmitter emitter;
    private final Map<String, String> brokerMetricsLabels;
    private final Set<String> excludeLabels;
    private final Context context;

    public ClientMetricsTelemetryReceiver(TelemetryEmitter emitter, Context context, Map<String, String> contextLabels, Set<String> excludeLabels) {
        this.emitter = emitter;
        this.context = context;
        this.brokerMetricsLabels = ClientLabels.getBrokerLabels(contextLabels);
        this.excludeLabels = excludeLabels;
    }

    public void exportMetrics(AuthorizableRequestContext authCtx, ClientTelemetryPayload payload) {
        MetricsData metricsData;
        if (payload == null || payload.data() == null) {
            log.warn("Client did not include payload when pushing to broker, skipping export");
            return;
        }
        try {
            metricsData = ClientMetricsTelemetryReceiver.deserializeMetricsData(payload.data());
        }
        catch (Exception exception) {
            log.error("Unable to deserialize metrics", (Throwable)exception);
            return;
        }
        if (metricsData == null || metricsData.getResourceMetricsCount() == 0) {
            log.warn("No client metrics available in request, skipping export");
            return;
        }
        Map<String, String> requestLabels = ClientLabels.getClientRequestLabels(authCtx, String.valueOf(payload.clientInstanceId()));
        for (ResourceMetrics resourceMetrics : metricsData.getResourceMetricsList()) {
            if (!this.validateResourceMetrics(resourceMetrics)) {
                log.debug("Client metrics has invalid resource metrics. Skipping the client metric.");
                continue;
            }
            for (Metric metric : resourceMetrics.getScopeMetrics(0).getMetricsList()) {
                if (!this.validateMetrics(metric)) {
                    log.debug("Client metrics has invalid scope metric. Skipping the client metric.");
                    continue;
                }
                MetricKey metricKey = new MetricKey(metric.getName(), Collections.emptyMap());
                if (!this.emitter.shouldEmitMetric(metricKey)) continue;
                this.emitter.emitMetric(new ClientExportableMetric(metric, metricKey, this.context, resourceMetrics.getResource(), this.brokerMetricsLabels, requestLabels, this.excludeLabels));
            }
        }
    }

    private boolean validateResourceMetrics(ResourceMetrics resourceMetrics) {
        if (resourceMetrics.getScopeMetricsCount() != 1) {
            log.debug("Client metrics has invalid scope metrics which is not supported. Metrics count: {}", (Object)resourceMetrics.getScopeMetricsCount());
            return false;
        }
        return true;
    }

    private boolean validateMetrics(Metric metric) {
        List<NumberDataPoint> numberDataPoints = MetricsUtils.extractDataPoints(metric);
        if (numberDataPoints.size() != 1) {
            log.debug("Client metrics has invalid data points.");
            return false;
        }
        return true;
    }

    private static MetricsData deserializeMetricsData(ByteBuffer serializedMetricsData) {
        try {
            return MetricsData.parseFrom((ByteBuffer)serializedMetricsData);
        }
        catch (IOException e) {
            throw new KafkaException("Unable to parse MetricsData payload", (Throwable)e);
        }
    }
}

