/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import com.google.common.base.Suppliers;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.MetricKey;
import io.confluent.telemetry.exporter.ExportableMetric;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.function.Supplier;

public class ContextExportableMetric
implements ExportableMetric {
    private final Metric metric;
    private final MetricKey key;
    private final Context context;
    private final Supplier<ResourceMetrics> resourceMetricsSupplier;

    public ContextExportableMetric(Metric metric, MetricKey key, Context context) {
        this.metric = metric;
        this.key = key;
        this.context = context;
        this.resourceMetricsSupplier = Suppliers.memoize(() -> ResourceMetrics.newBuilder().setResource(context.getResource()).addScopeMetrics(ScopeMetrics.newBuilder().setScope(context.getInstrumentationScope()).addMetrics(metric).build()).build());
    }

    @Override
    public MetricKey key() {
        return this.key;
    }

    @Override
    public Metric metric() {
        return this.metric;
    }

    @Override
    public Resource resource() {
        return this.context.getResource();
    }

    @Override
    public InstrumentationScope instrumentationScope() {
        return this.context.getInstrumentationScope();
    }

    @Override
    public ResourceMetrics resourceMetrics() {
        return this.resourceMetricsSupplier.get();
    }
}

