/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.emitter;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.Context;
import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.emitter.ContextExportableMetric;
import io.confluent.telemetry.emitter.Emitter;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.metrics.Keyed;
import io.confluent.telemetry.metrics.SinglePointMetric;
import io.opentelemetry.proto.metrics.v1.Metric;
import java.util.Collection;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Meter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelemetryEmitter
implements Emitter {
    public static final Logger log = LoggerFactory.getLogger(TelemetryEmitter.class);
    private static final String METRICS_GROUP = "TelemetryEmitter";
    private final Context context;
    private final Supplier<Collection<Exporter>> exportersSupplier;
    private volatile Predicate<? super Keyed> metricsPredicate = PredicateUtils.ALWAYS_FALSE;
    private final Sensor exportedMetricsSensor;

    public TelemetryEmitter(Context context, Supplier<Collection<Exporter>> exportersSupplier, Metrics metrics) {
        this.context = context;
        this.exportersSupplier = exportersSupplier;
        this.exportedMetricsSensor = metrics.sensor("exported-records");
        this.exportedMetricsSensor.add((CompoundStat)new Meter(metrics.metricName(this.exportedMetricsSensor.name() + "-rate", METRICS_GROUP), metrics.metricName(this.exportedMetricsSensor.name() + "-total", METRICS_GROUP)));
    }

    @Override
    public boolean shouldEmitMetric(Keyed key) {
        return this.metricsPredicate.test(key);
    }

    @Override
    public boolean emitMetric(SinglePointMetric metric) {
        Metric builtMetric = metric.metric().build();
        ContextExportableMetric exportableMetric = new ContextExportableMetric(builtMetric, metric.key(), this.context);
        return this.emitMetric(exportableMetric);
    }

    public boolean emitMetric(ContextExportableMetric exportableMetric) {
        boolean exported = false;
        for (Exporter e : this.exportersSupplier.get()) {
            try {
                exported |= e.emit(exportableMetric);
            }
            catch (Exception ex) {
                log.error("Error emitting metrics for exporter: {}", (Object)e.getName(), (Object)ex);
            }
        }
        if (exported) {
            this.exportedMetricsSensor.record();
        }
        return exported;
    }

    public void reconfigurePredicate(Predicate<? super Keyed> metricsPredicate) {
        Preconditions.checkNotNull(metricsPredicate, (Object)"metricsPredicate can't be null");
        this.metricsPredicate = metricsPredicate;
    }
}

