/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.emitter.ContextExportableMetric;
import io.confluent.telemetry.exporter.Exporter;
import io.confluent.telemetry.metrics.Keyed;
import java.util.function.Predicate;

public abstract class AbstractExporter
implements Exporter {
    private final String name;
    private volatile Predicate<Keyed> metricsPredicate;

    public AbstractExporter(Predicate<Keyed> metricsPredicate, String name) {
        this.metricsPredicate = metricsPredicate;
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Exporter name can't be null or empty");
        }
        this.name = name;
    }

    @Override
    public Predicate<Keyed> getPredicate() {
        return this.metricsPredicate;
    }

    @Override
    public void reconfigurePredicate(Predicate<Keyed> metricsPredicate) {
        Preconditions.checkNotNull(metricsPredicate, (Object)"metricsPredicate can't be null");
        this.metricsPredicate = metricsPredicate;
    }

    public abstract void doEmit(ContextExportableMetric var1);

    @Override
    public final boolean emit(ContextExportableMetric exportableMetric) {
        if (this.shouldEmitMetric(exportableMetric)) {
            this.doEmit(exportableMetric);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    private boolean shouldEmitMetric(Keyed key) {
        return this.metricsPredicate.test(key);
    }
}

