/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import com.google.common.base.Preconditions;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.kafka.ProducerClientConfig;
import java.util.Arrays;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public abstract class ClientConfig
extends AbstractConfig {
    private final String name;
    private final boolean doLog;
    public static final String TYPE_CONFIG = "type";
    public static final String TYPE_CONFIG_DOC = "The type of the client config. Value must be one of " + Arrays.toString((Object[])ClientConfigType.values());

    private static ConfigDef defineClientConfig(ConfigDef def) {
        return new ConfigDef(def).define(TYPE_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, TYPE_CONFIG_DOC);
    }

    public ClientConfig(String name, ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(ClientConfig.defineClientConfig(definition), originals, doLog);
        this.name = name;
        this.doLog = doLog;
    }

    public String getName() {
        return this.name;
    }

    public ClientConfigType getType() {
        return ClientConfig.parseType(this.getString(TYPE_CONFIG));
    }

    public static ClientConfigType parseType(Object value) {
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigException("'type' is a required config");
        }
        try {
            return ClientConfigType.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("'type' must be one of: " + String.valueOf(Arrays.asList(ClientConfigType.values())) + " however we found '" + String.valueOf(value) + "'");
        }
    }

    public ClientConfig reconfigure(Map<String, ?> overrides) {
        Map newRawConfig = this.originals();
        newRawConfig.putAll(overrides);
        ClientConfigType oldClientConfigType = this.getType();
        ClientConfigType newClientConfigType = ClientConfig.parseType(newRawConfig.get(TYPE_CONFIG));
        Preconditions.checkArgument((newClientConfigType == oldClientConfigType ? 1 : 0) != 0, (String)"Reconfigured Named Client must stay the same type (old=%s new=%s)", (Object)((Object)oldClientConfigType), (Object)((Object)newClientConfigType));
        if (ClientConfigType.kafkaProducer.equals((Object)oldClientConfigType)) {
            return new ProducerClientConfig(this.name, newRawConfig, this.doLog);
        }
        if (ClientConfigType.httpTelemetryClient.equals((Object)oldClientConfigType)) {
            return new HttpClientConfig(this.name, newRawConfig, this.doLog);
        }
        throw new RuntimeException("unexpected Client Config Type value");
    }

    public static enum ClientConfigType {
        kafkaProducer,
        httpTelemetryClient;

    }
}

