/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import java.io.Closeable;
import java.io.IOException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CloseableReferenceTracker<R, T extends Closeable> {
    private static final Logger log = LoggerFactory.getLogger(CloseableReferenceTracker.class);
    private final String clientName;
    private final Set<UUID> leases = ConcurrentHashMap.newKeySet();
    private final CloseableFactory<R, T> factory;
    private volatile T closeable = null;
    private volatile R config = null;

    public CloseableReferenceTracker(String clientName, CloseableFactory<R, T> factory) {
        this.clientName = clientName;
        this.factory = factory;
    }

    public synchronized void setConfig(R config) {
        log.info("Updating config for CloseableReferenceTracker, name: " + this.clientName);
        if (this.closeable != null && !config.equals(this.config)) {
            throw new ConfigException("Client Config " + this.clientName + " already exists with different config");
        }
        this.config = config;
    }

    public synchronized T register(UUID lease) {
        if (this.config == null) {
            throw new IllegalStateException("Tried to register in CloseableReferenceTracker before providing any config, name: " + this.clientName + ", lease: " + String.valueOf(lease));
        }
        log.info("Adding lease to CloseableReferenceTracker, name: " + this.clientName + ", lease: " + String.valueOf(lease));
        this.leases.add(lease);
        if (this.closeable == null) {
            log.info("Creating new closeable resource in CloseableReferenceTracker, name: " + this.clientName + ", lease: " + String.valueOf(lease));
            this.closeable = (Closeable)this.factory.create(this.config);
        }
        return this.closeable;
    }

    public synchronized void unregister(UUID lease) throws IOException {
        log.info("Removing lease from CloseableReferenceTracker, name " + this.clientName + ", lease: " + String.valueOf(lease));
        this.leases.remove(lease);
        if (this.leases.isEmpty()) {
            try {
                log.info("Closing resource for CloseableReferenceTracker, name " + this.clientName + ", lease: " + String.valueOf(lease));
                this.closeable.close();
            }
            finally {
                this.closeable = null;
            }
        }
    }

    public static interface CloseableFactory<R, T> {
        public T create(R var1);
    }
}

