/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import io.confluent.telemetry.metrics.Keyed;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceRequest;
import io.opentelemetry.proto.common.v1.InstrumentationScope;
import io.opentelemetry.proto.metrics.v1.Metric;
import io.opentelemetry.proto.metrics.v1.MetricsData;
import io.opentelemetry.proto.metrics.v1.ResourceMetrics;
import io.opentelemetry.proto.metrics.v1.ScopeMetrics;
import io.opentelemetry.proto.resource.v1.Resource;
import java.util.ArrayList;
import java.util.Collection;

public interface ExportableMetric
extends Keyed {
    public static MetricsData buildMetricsData(ExportableMetric exportable) {
        return MetricsData.newBuilder().addResourceMetrics(exportable.resourceMetrics()).build();
    }

    public static ExportMetricsServiceRequest buildRequest(Collection<ExportableMetric> exportables) {
        ExportableMetric first = exportables.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No exportable metrics found"));
        Resource resource = first.resource();
        InstrumentationScope instrumentationScope = first.instrumentationScope();
        ArrayList metrics = new ArrayList();
        exportables.forEach(exportable -> metrics.add(exportable.metric()));
        return ExportMetricsServiceRequest.newBuilder().addResourceMetrics(ResourceMetrics.newBuilder().setResource(resource).addScopeMetrics(ScopeMetrics.newBuilder().setScope(instrumentationScope).addAllMetrics(metrics).build()).build()).build();
    }

    public Metric metric();

    public Resource resource();

    public InstrumentationScope instrumentationScope();

    public ResourceMetrics resourceMetrics();
}

