/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.confluent.telemetry.PredicateUtils;
import io.confluent.telemetry.RegexConfigDefValidator;
import io.confluent.telemetry.exporter.ClientConfig;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.kafka.KafkaExporterConfig;
import io.confluent.telemetry.exporter.kafka.ProducerClientConfig;
import io.confluent.telemetry.metrics.Keyed;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;

public abstract class ExporterConfig
extends AbstractConfig {
    private final String name;
    private final Boolean doLog;
    public static final String NAMED_CLIENT_CONFIGURED_DOC_WARNING = " However, if a named exporter client is configured, this value should not be set";
    public static final String ENABLED_CONFIG = "enabled";
    public static final String ENABLED_CONFIG_DOC = "Boolean value. True if exporter should be enabled, false otherwise. This is a mandatory field that has to be set for every exporter.";
    public static final String TYPE_CONFIG = "type";
    public static final String TYPE_CONFIG_DOC = "The type of the exporter. Value must be one of " + String.valueOf(Arrays.asList(ExporterType.values()));
    public static final String CLIENT_NAME_CONFIG = "client";
    public static final String CLIENT_NAME_CONFIG_DOC = "The name of the configured client to use for the exporter";
    public static final String CLIENT_NAME_CONFIG_DEFAULT = "";
    public static final String METRICS_INCLUDE_CONFIG = "metrics.include";
    public static final String METRICS_INCLUDE_CONFIG_DOC = "Regex matching the converted (snake_case) metric name to be published from this particular exporter.\n\nBy default this includes all the metrics required by Proactive Support and Self-balancing Clusters. This should typically never be modified unless requested by Confluent.";
    public static final String METRICS_ENABLED_CONFIG = "metrics.enabled";
    public static final String METRICS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry metrics should be reported.";
    public static final boolean METRICS_ENABLED_CONFIG_DEFAULT = true;
    public static final String EVENTS_ENABLED_CONFIG = "events.enabled";
    public static final String EVENTS_ENABLED_CONFIG_DOC = "Boolean value. True if telemetry events should be reported.";
    public static final boolean EVENTS_ENABLED_CONFIG_DEFAULT = true;
    public static final String REMOTE_CONFIGURABLE_CONFIG = "remote.configurable";
    public static final String REMOTE_CONFIGURABLE_CONFIG_DOC = "Boolean value. True if the exporter should be remotely configurable.";
    public static final boolean REMOTE_CONFIGURABLE_CONFIG_DEFAULT = true;
    public static final Set<String> RECONFIGURABLES = ImmutableSet.of((Object)"enabled", (Object)"metrics.include");

    private static ConfigDef defineExporterConfigs(ConfigDef def) {
        return new ConfigDef(def).define(ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, ConfigDef.NO_DEFAULT_VALUE, ConfigDef.Importance.LOW, ENABLED_CONFIG_DOC).define(TYPE_CONFIG, ConfigDef.Type.STRING, ConfigDef.NO_DEFAULT_VALUE, (ConfigDef.Validator)ConfigDef.LambdaValidator.with((name, value) -> ExporterConfig.parseType(value), () -> Arrays.asList(ExporterType.values()).toString()), ConfigDef.Importance.LOW, TYPE_CONFIG_DOC).define(CLIENT_NAME_CONFIG, ConfigDef.Type.STRING, (Object)CLIENT_NAME_CONFIG_DEFAULT, ConfigDef.Importance.LOW, CLIENT_NAME_CONFIG_DOC).define(METRICS_INCLUDE_CONFIG, ConfigDef.Type.STRING, null, new ConfigDef.Validator(){
            private final ConfigDef.Validator regexValidator = new RegexConfigDefValidator("Metrics filter for configuration");

            public void ensureValid(String name, Object value) {
                if (value != null) {
                    this.regexValidator.ensureValid(name, value);
                }
            }
        }, ConfigDef.Importance.LOW, METRICS_INCLUDE_CONFIG_DOC).define(METRICS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, METRICS_ENABLED_CONFIG_DOC).define(EVENTS_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, EVENTS_ENABLED_CONFIG_DOC).define(REMOTE_CONFIGURABLE_CONFIG, ConfigDef.Type.BOOLEAN, (Object)true, ConfigDef.Importance.LOW, REMOTE_CONFIGURABLE_CONFIG_DOC);
    }

    public static ExporterType parseType(Object value) {
        if (value == null || value.toString().isEmpty()) {
            throw new ConfigException("'type' is a required config");
        }
        try {
            return ExporterType.valueOf(value.toString());
        }
        catch (IllegalArgumentException e) {
            throw new ConfigException("'type' must be one of: " + String.valueOf(Arrays.asList(ExporterType.values())) + " however we found '" + String.valueOf(value) + "'");
        }
    }

    public ExporterConfig(String name, ConfigDef definition, Map<?, ?> originals, boolean doLog) {
        super(ExporterConfig.defineExporterConfigs(definition), originals, doLog);
        this.name = name;
        this.doLog = doLog;
    }

    public String getName() {
        return this.name;
    }

    public ExporterType getType() {
        return ExporterConfig.parseType(this.getString(TYPE_CONFIG));
    }

    public boolean isEnabled() {
        return this.getBoolean(ENABLED_CONFIG);
    }

    public boolean isMetricsEnabled() {
        return this.getBoolean(METRICS_ENABLED_CONFIG);
    }

    public boolean isRemoteConfigurable() {
        return this.getBoolean(REMOTE_CONFIGURABLE_CONFIG);
    }

    public ExporterConfig reconfigure(Map<String, ?> overrides, Map<String, ClientConfig> clientConfigMap) {
        Map newRawConfig = this.originals();
        newRawConfig.putAll(overrides);
        ExporterType oldExporterType = this.getType();
        ExporterType newExporterType = ExporterConfig.parseType(newRawConfig.get(TYPE_CONFIG));
        Preconditions.checkArgument((newExporterType == oldExporterType ? 1 : 0) != 0, (String)"Reconfigured Exporter must stay the same type (old=%s new=%s)", (Object)((Object)oldExporterType), (Object)((Object)newExporterType));
        String oldClientName = (String)this.originals().get(CLIENT_NAME_CONFIG);
        String newClientName = (String)newRawConfig.get(CLIENT_NAME_CONFIG);
        if (oldClientName == null && newClientName != null || oldClientName != null && newClientName == null) {
            throw new ConfigException("Use or disuse of static client must be consistent across reconfigurations");
        }
        if (ExporterType.kafka.equals((Object)newExporterType)) {
            return this.createKafkaExporterConfig(newClientName, clientConfigMap, newRawConfig);
        }
        if (ExporterType.http.equals((Object)newExporterType)) {
            return this.createHttpExporterConfig(newClientName, clientConfigMap, newRawConfig);
        }
        throw new RuntimeException("unexpected ExporterType value");
    }

    public Optional<Predicate<Keyed>> buildMetricsPredicate() {
        String includeList = this.getString(METRICS_INCLUDE_CONFIG);
        if (includeList != null) {
            return Optional.of(PredicateUtils.buildCachingMetricsPredicate(includeList));
        }
        return Optional.empty();
    }

    private KafkaExporterConfig createKafkaExporterConfig(String clientName, Map<String, ClientConfig> clientConfigMap, Map<String, Object> newRawConfig) {
        if (clientName == null) {
            return new KafkaExporterConfig(this.name, newRawConfig, this.doLog);
        }
        ProducerClientConfig clientConfig = (ProducerClientConfig)clientConfigMap.get(clientName);
        if (clientConfig == null) {
            throw new ConfigException("Client config not found for exporter " + this.name + " with client name " + clientName);
        }
        return new KafkaExporterConfig(this.name, newRawConfig, clientConfig, (boolean)this.doLog);
    }

    private HttpExporterConfig createHttpExporterConfig(String clientName, Map<String, ClientConfig> clientConfigMap, Map<String, Object> newRawConfig) {
        if (clientName == null) {
            return new HttpExporterConfig(this.name, newRawConfig, this.doLog);
        }
        HttpClientConfig clientConfig = (HttpClientConfig)clientConfigMap.get(clientName);
        if (clientConfig == null) {
            throw new ConfigException("Client config not found for exporter " + this.name + " with client name " + clientName);
        }
        return new HttpExporterConfig(this.name, newRawConfig, clientConfig, (boolean)this.doLog);
    }

    public static enum ExporterType {
        http,
        kafka;

    }
}

