/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter;

import io.confluent.telemetry.exporter.CloseableReferenceTracker;
import java.io.Closeable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferenceTrackingProxy<R, T extends Closeable>
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(ReferenceTrackingProxy.class);
    private final CloseableReferenceTracker<R, T> referenceTracker;
    private final T closeable;
    private final UUID lease;

    private ReferenceTrackingProxy(CloseableReferenceTracker<R, T> referenceTracker, T closeable, UUID lease) {
        this.referenceTracker = referenceTracker;
        this.closeable = closeable;
        this.lease = lease;
    }

    public static <R, T extends Closeable> T createProxy(CloseableReferenceTracker<R, T> referenceTracker) {
        UUID uuid = UUID.randomUUID();
        T closeable = referenceTracker.register(uuid);
        return (T)((Closeable)Proxy.newProxyInstance(closeable.getClass().getClassLoader(), closeable.getClass().getInterfaces(), new ReferenceTrackingProxy<R, T>(referenceTracker, closeable, uuid)));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("close")) {
            log.info("Closing referencing tracking proxy with UUID " + String.valueOf(this.lease));
            this.referenceTracker.unregister(this.lease);
            return null;
        }
        return method.invoke(this.closeable, args);
    }
}

