/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.client.TelemetryHttpClient;
import io.confluent.telemetry.exporter.ClientConfig;
import io.confluent.telemetry.exporter.http.HttpConfigUtils;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;

public class HttpClientConfig
extends ClientConfig {
    public static final String PREFIX_API = "api.";
    public static final String API_KEY = "api.key";
    public static final String API_KEY_DOC = "The API key used to authenticate the requests made by HttpExporter.";
    public static final String API_SECRET = "api.secret";
    public static final String API_SECRET_DOC = "The API secret used to authenticate requests made by HttpExporter.";
    public static final String PREFIX_BUFFER = "buffer.";
    public static final String BUFFER_MAX_BATCH_DURATION_MS = "buffer.batch.duration.max.ms";
    public static final String BUFFER_MAX_BATCH_DURATION_MS_DOC = "The maximum duration (in millis) to buffer items before sending them upstream.";
    public static final String BUFFER_MAX_BATCH_SIZE = "buffer.batch.items.max";
    public static final String BUFFER_MAX_BATCH_SIZE_DOC = "The maximum number of items to buffer into a batch before sending them upstream.";
    public static final String BUFFER_MAX_PENDING_BATCHES = "buffer.pending.batches.max";
    public static final String BUFFER_MAX_PENDING_BATCHES_DOC = "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped.";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS = "buffer.inflight.submissions.max";
    public static final String BUFFER_MAX_INFLIGHT_SUBMISSIONS_DOC = "The maximum number of in-flight calls to the HTTP service.";
    public static final String PREFIX_CLIENT = "client.";
    public static final String CLIENT_BASE_URL = "client.base.url";
    public static final String CLIENT_BASE_URL_DOC = "The base URL for the telemetry receiver (i.e. https://host:port).";
    public static final String CLIENT_METRICS_PATH = "client.metrics.path.override";
    public static final String CLIENT_METRICS_PATH_DOC = "The URL path to post metrics to for metrics (i.e. /v1/metrics_override).";
    public static final String CLIENT_METRICS_PATH_DEFAULT = "/v1/metrics";
    public static final String CLIENT_REQUEST_TIMEOUT_MS = "client.request.timeout.ms";
    public static final String CLIENT_REQUEST_TIMEOUT_MS_DOCS = "The request timeout in milliseconds.";
    public static final String CLIENT_CONNECT_TIMEOUT_MS = "client.connect.timeout.ms";
    public static final String CLIENT_CONNECT_TIMEOUT_MS_DOC = "The connect timeout in milliseconds.";
    public static final String CLIENT_MAX_ATTEMPTS = "client.attempts.max";
    public static final String CLIENT_MAX_ATTEMPTS_DOC = "The maximum number of delivery attempts.";
    public static final String CLIENT_RETRY_DELAY_SEC = "client.retry.delay.seconds";
    public static final String CLIENT_RETRY_DELAY_SEC_DOC = "The delay, in seconds, between retry attempts.";
    public static final String CLIENT_COMPRESSION = "client.compression";
    public static final String CLIENT_COMPRESSION_DOC = "HTTP Compression algorithm to use. Either gzip, lz4, or zstd.";
    public static final String PREFIX_PROXY = "proxy.";
    public static final String PROXY_URL = "proxy.url";
    public static final String PROXY_URL_DOC = "The URL for an explicit (i.e. not transparent) forward HTTP proxy.";
    public static final String PROXY_USERNAME = "proxy.username";
    public static final String PROXY_USERNAME_DOC = "The username credential for the forward HTTP proxy.";
    public static final String PROXY_PASSWORD = "proxy.password";
    public static final String PROXY_PASSWORD_DOC = "The password credential for the forward HTTP proxy.";
    public static final Set<String> RECONFIGURABLE_CONFIGS = Set.of("api.key", "api.secret", "proxy.url", "proxy.username", "proxy.password");
    private static final ConfigDef CONFIG_DEF = new ConfigDef().define("api.key", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "The API key used to authenticate the requests made by HttpExporter.").define("api.secret", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.HIGH, "The API secret used to authenticate requests made by HttpExporter.").define("buffer.batch.duration.max.ms", ConfigDef.Type.LONG, null, ConfigDef.Importance.LOW, "The maximum duration (in millis) to buffer items before sending them upstream.").define("buffer.batch.items.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of items to buffer into a batch before sending them upstream.").define("buffer.pending.batches.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of pending batches. If more than this number of batches are pending(i.e. there is backpressure) then the oldest batches will be dropped.").define("buffer.inflight.submissions.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of in-flight calls to the HTTP service.").define("client.base.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpConfigUtils.URIValidator(), ConfigDef.Importance.LOW, "The base URL for the telemetry receiver (i.e. https://host:port).").defineInternal("client.metrics.path.override", ConfigDef.Type.STRING, (Object)"/v1/metrics", ConfigDef.Importance.LOW, "The URL path to post metrics to for metrics (i.e. /v1/metrics_override).").define("client.compression", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "HTTP Compression algorithm to use. Either gzip, lz4, or zstd.").define("client.request.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The request timeout in milliseconds.").define("client.connect.timeout.ms", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The connect timeout in milliseconds.").define("client.attempts.max", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The maximum number of delivery attempts.").define("client.retry.delay.seconds", ConfigDef.Type.INT, null, ConfigDef.Importance.LOW, "The delay, in seconds, between retry attempts.").define("proxy.url", ConfigDef.Type.STRING, null, (ConfigDef.Validator)new HttpConfigUtils.URIValidator(), ConfigDef.Importance.LOW, "The URL for an explicit (i.e. not transparent) forward HTTP proxy.").define("proxy.username", ConfigDef.Type.STRING, null, ConfigDef.Importance.LOW, "The username credential for the forward HTTP proxy.").define("proxy.password", ConfigDef.Type.PASSWORD, null, ConfigDef.Importance.LOW, "The password credential for the forward HTTP proxy.");

    public HttpClientConfig(String name, Map<?, ?> originals, boolean doLog) {
        super(name, CONFIG_DEF, originals, doLog);
    }

    public String getClientMetricsPath() {
        return HttpConfigUtils.getClientMetricsPath(this);
    }

    public Credentials getCredentials() {
        return HttpConfigUtils.getCredentials(this);
    }

    public ProxyConfig getProxyConfig() {
        return HttpConfigUtils.getProxyConfig(this);
    }

    public <T, S> TelemetryHttpClient.Builder<T, S> configureClientDefaults(TelemetryHttpClient.Builder<T, S> builder) {
        return HttpConfigUtils.configureClientDefaults(builder, this);
    }
}

