/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import io.confluent.telemetry.client.BufferingAsyncClient;
import io.confluent.telemetry.exporter.CloseableReferenceTracker;
import io.confluent.telemetry.exporter.ExportableMetric;
import io.confluent.telemetry.exporter.ReferenceTrackingProxy;
import io.confluent.telemetry.exporter.http.HttpClientConfig;
import io.confluent.telemetry.exporter.http.HttpExporterConfigWrapper;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientFactory {
    private static final Logger log = LoggerFactory.getLogger(HttpClientFactory.class);
    private static final HttpClientFactory INSTANCE = new HttpClientFactory();
    private final ConcurrentMap<String, CloseableReferenceTracker<HttpExporterConfigWrapper, BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse>>> bufferingClients = new ConcurrentHashMap<String, CloseableReferenceTracker<HttpExporterConfigWrapper, BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse>>>();

    public static HttpClientFactory getInstance() {
        return INSTANCE;
    }

    public synchronized BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse> get(HttpExporterConfigWrapper configWrapper) {
        HttpClientConfig clientConfig = configWrapper.getConfig().getClientConfig();
        if (clientConfig != null) {
            CloseableReferenceTracker tracker = this.bufferingClients.computeIfAbsent(clientConfig.getName(), this::createTracker);
            tracker.setConfig(configWrapper);
            return (BufferingAsyncClient)ReferenceTrackingProxy.createProxy(tracker);
        }
        log.info("Creating new non-static HTTP client");
        return configWrapper.createBufferingClient();
    }

    private CloseableReferenceTracker<HttpExporterConfigWrapper, BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse>> createTracker(String clientName) {
        log.info("Creating new CloseableReferenceTracker for config {}", (Object)clientName);
        return new CloseableReferenceTracker<HttpExporterConfigWrapper, BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse>>(clientName, HttpExporterConfigWrapper::createBufferingClient);
    }
}

