/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import com.google.common.base.Strings;
import io.confluent.telemetry.client.CompressionAlgorithm;
import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.client.TelemetryHttpClient;
import java.net.URI;
import java.util.Locale;
import java.util.Optional;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.types.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpConfigUtils {
    private static final Logger log = LoggerFactory.getLogger(HttpConfigUtils.class);

    private HttpConfigUtils() {
    }

    static <T, S> TelemetryHttpClient.Builder<T, S> configureClientDefaults(TelemetryHttpClient.Builder<T, S> builder, AbstractConfig config) {
        HttpConfigUtils.getClientBaseUrl(config).ifPresent(arg_0 -> builder.setBaseUrl(arg_0));
        HttpConfigUtils.getClientRequestTimeoutMs(config).ifPresent(arg_0 -> builder.setRequestTimeout(arg_0));
        HttpConfigUtils.getClientConnectTimeoutMs(config).ifPresent(arg_0 -> builder.setConnectTimeout(arg_0));
        HttpConfigUtils.getClientMaxAttempts(config).ifPresent(arg_0 -> builder.setMaxAttempts(arg_0));
        HttpConfigUtils.getClientRetryDelaySec(config).ifPresent(arg_0 -> builder.setRetryDelay(arg_0));
        HttpConfigUtils.getCompressionAlgorithm(config).ifPresent(arg_0 -> builder.setCompression(arg_0));
        return builder;
    }

    static Credentials getCredentials(AbstractConfig config) {
        return HttpConfigUtils.createValidatedCredentials(HttpConfigUtils.getApiKey(config), HttpConfigUtils.getApiSecret(config), "Must specify both api.key and api.secret");
    }

    static ProxyConfig getProxyConfig(AbstractConfig config) {
        String proxyUrl = HttpConfigUtils.getProxyUrl(config);
        if (Strings.isNullOrEmpty((String)proxyUrl)) {
            return null;
        }
        URI proxyUri = URI.create(proxyUrl);
        Credentials credentials = HttpConfigUtils.createValidatedCredentials(HttpConfigUtils.getProxyUsername(config), HttpConfigUtils.getProxyPassword(config), "Must specify both proxy.username and proxy.password");
        return new ProxyConfig(proxyUri, credentials);
    }

    static Optional<CompressionAlgorithm> getCompressionAlgorithm(AbstractConfig config) {
        String compressionName = config.getString("client.compression");
        if (compressionName == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(CompressionAlgorithm.valueOf((String)compressionName.toUpperCase(Locale.US)));
        }
        catch (IllegalArgumentException e) {
            log.warn("Unsupported compression algorithm specified for Telemetry Metrics Reporter Client: {}", (Object)compressionName);
            return Optional.empty();
        }
    }

    static Optional<URI> getClientBaseUrl(AbstractConfig config) {
        return Optional.ofNullable(config.getString("client.base.url")).map(URI::create);
    }

    static String getClientMetricsPath(AbstractConfig config) {
        return config.getString("client.metrics.path.override");
    }

    static Optional<Integer> getClientRequestTimeoutMs(AbstractConfig config) {
        return Optional.ofNullable(config.getInt("client.request.timeout.ms"));
    }

    static Optional<Integer> getClientConnectTimeoutMs(AbstractConfig config) {
        return Optional.ofNullable(config.getInt("client.connect.timeout.ms"));
    }

    static Optional<Integer> getClientMaxAttempts(AbstractConfig config) {
        return Optional.ofNullable(config.getInt("client.attempts.max"));
    }

    static Optional<Integer> getClientRetryDelaySec(AbstractConfig config) {
        return Optional.ofNullable(config.getInt("client.retry.delay.seconds"));
    }

    private static String getApiKey(AbstractConfig config) {
        return config.getString("api.key");
    }

    private static String getApiSecret(AbstractConfig config) {
        return Optional.ofNullable(config.getPassword("api.secret")).map(Password::value).orElse(null);
    }

    private static Credentials createValidatedCredentials(String username, String password, String errorMessage) {
        if (Strings.isNullOrEmpty((String)username) && Strings.isNullOrEmpty((String)password)) {
            return null;
        }
        if (!Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password)) {
            return new Credentials(username, password);
        }
        throw new ConfigException(errorMessage);
    }

    private static String getProxyUrl(AbstractConfig config) {
        return config.getString("proxy.url");
    }

    private static String getProxyUsername(AbstractConfig config) {
        return config.getString("proxy.username");
    }

    private static String getProxyPassword(AbstractConfig config) {
        return Optional.ofNullable(config.getPassword("proxy.password")).map(Password::value).orElse(null);
    }

    public static class URIValidator
    implements ConfigDef.Validator {
        public void ensureValid(String name, Object value) {
            if (value == null) {
                return;
            }
            if (!(value instanceof String)) {
                throw new ConfigException("Valid URI expected: " + name);
            }
            try {
                URI.create((String)value);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(String.format("Invalid URI for property: %s (value: %s)", name, value));
            }
        }
    }
}

