/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.telemetry.exporter.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.confluent.telemetry.client.BufferingAsyncClient;
import io.confluent.telemetry.client.BufferingAsyncTelemetryHttpClientStats;
import io.confluent.telemetry.client.Credentials;
import io.confluent.telemetry.client.ProxyConfig;
import io.confluent.telemetry.emitter.ContextExportableMetric;
import io.confluent.telemetry.exporter.AbstractExporter;
import io.confluent.telemetry.exporter.ExportableMetric;
import io.confluent.telemetry.exporter.http.HttpClientFactory;
import io.confluent.telemetry.exporter.http.HttpExporterConfig;
import io.confluent.telemetry.exporter.http.HttpExporterConfigWrapper;
import io.confluent.telemetry.metrics.Keyed;
import io.opentelemetry.proto.collector.metrics.v1.ExportMetricsServiceResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpExporter
extends AbstractExporter {
    public static final String SELF_METRICS_GROUP = "HttpExporter";
    private static final Logger log = LoggerFactory.getLogger(HttpExporter.class);
    private static final HttpClientFactory HTTP_CLIENT_FACTORY = HttpClientFactory.getInstance();
    private final BufferingAsyncClient<ExportableMetric, ExportMetricsServiceResponse> bufferingClient;
    @VisibleForTesting
    volatile Credentials credentials;
    @VisibleForTesting
    volatile ProxyConfig proxyConfig;
    private Metrics metrics;
    private final Set<MetricName> metricNames = new HashSet<MetricName>();

    public HttpExporter(Predicate<Keyed> metricsPredicate, String name, HttpExporterConfig config) {
        super(metricsPredicate, name);
        HttpExporterConfigWrapper configWrapper = new HttpExporterConfigWrapper(config, () -> this.credentials, () -> this.proxyConfig);
        log.info("Http Exporter {} getting HTTP client {}", (Object)config.getName(), (Object)config.getClientName());
        this.bufferingClient = HTTP_CLIENT_FACTORY.get(configWrapper);
        this.setDynamicFields(config);
    }

    public void setDynamicFields(HttpExporterConfig config) {
        this.credentials = config.getCredentials();
        if (this.credentials == null) {
            log.error("API Key/Secret are missing for the exporter '{}'. The exporter will not be able to emit metrics.", (Object)this.getName());
        }
        this.proxyConfig = config.getProxyConfig();
    }

    @VisibleForTesting
    BufferingAsyncTelemetryHttpClientStats stats() {
        return this.bufferingClient.stats();
    }

    @Override
    public void doEmit(ContextExportableMetric metric) {
        if (this.credentials == null) {
            return;
        }
        this.bufferingClient.submit(Collections.singleton(metric));
    }

    @Override
    public void close() throws IOException {
        this.bufferingClient.close();
        for (MetricName metricName : this.metricNames) {
            this.metrics.removeMetric(metricName);
        }
    }

    @Override
    public void setMetricsRegistry(Metrics metrics) {
        Preconditions.checkState((boolean)this.metricNames.isEmpty());
        this.metrics = metrics;
        Map<String, String> tags = Collections.singletonMap("exporterName", this.getName());
        ImmutableMap.of((Object)"items-total", (c, now) -> this.bufferingClient.stats().getTotalItems(), (Object)"items-failed", (c, now) -> this.bufferingClient.stats().getTotalFailedItems(), (Object)"items-succeeded", (c, now) -> this.bufferingClient.stats().getTotalSuccessfulItems(), (Object)"batches-total", (c, now) -> this.bufferingClient.stats().getTotalBatches(), (Object)"batches-dropped", (c, now) -> this.bufferingClient.stats().getTotalDroppedBatches(), (Object)"batches-failed", (c, now) -> this.bufferingClient.stats().getTotalFailedBatches(), (Object)"batches-succeeded", (c, now) -> this.bufferingClient.stats().getTotalSuccessfulBatches(), (Object)"send-time-total-millis", (c, now) -> this.bufferingClient.stats().getTotalSendTimeMs()).forEach((name, callback) -> {
            MetricName metricName = metrics.metricName(name, SELF_METRICS_GROUP, tags);
            metrics.addMetric(metricName, callback);
            this.metricNames.add(metricName);
        });
    }
}

